(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    111627,       2139]
NotebookOptionsPosition[    110828,       2110]
NotebookOutlinePosition[    111344,       2128]
CellTagsIndexPosition[    111301,       2125]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinDynamica`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.604056579832571*^9, 3.604056586881423*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "obspkg"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"PhysicalConstants`\\\"\\)\[NoBreak] is \
now obsolete. The legacy version being loaded may conflict with current \
Mathematica functionality. See the Compatibility Guide for updating \
information.\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.604847132659232*^9}],

Cell[BoxData[
 TagBox[
  FrameBox["\<\"SpinDynamica version 2.8.3 loaded\"\>"],
  DisplayForm]], "Print",
 CellChangeTimes->{3.604056588782641*^9, 3.6040590933714247`*^9, 
  3.604847133768249*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Graphics3D", ",", 
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ViewVertical", "\[Rule]", "ez"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"5", 
      RowBox[{"{", 
       RowBox[{"2", ",", ".3", ",", ".6"}], "}"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"1.1", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", "3", "}"}]}], "]"}]}]}]}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.604056808558495*^9, 3.604056825354374*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "20", ",", "30"}], "}"}], "\[Degree]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"X", ",", "Y", ",", "Z"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"ex", ",", "ey", ",", "ez"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"RotateEuler", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], "]"}],
      "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{"X", ",", "Y", ",", "Z"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xyplane", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}], "+", 
          RowBox[{"y", " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", "0", ",", 
           RowBox[{"2", "\[Pi]"}], ",", 
           RowBox[{"2", 
            RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"XYplane", "=", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
      RowBox[{"Polygon", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"X", " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}], "+", 
          RowBox[{"Y", " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", "0", ",", 
           RowBox[{"2", "\[Pi]"}], ",", 
           RowBox[{"2", 
            RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Axes3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"X", ",", "Y", ",", "Z"}], "}"}], ",", 
     RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Axes3D", "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "xyplane", ",", "\[IndentingNewLine]", "XYplane"}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.604056611525753*^9, 3.604056789904429*^9}, {
  3.6040568294813843`*^9, 3.604056872279793*^9}, {3.604056915287949*^9, 
  3.604057051315474*^9}, {3.604057086048457*^9, 3.6040572206581*^9}}],

Cell[BoxData[
 Graphics3DBox[{{
    {Arrowheads[Medium], Arrow3DBox[TubeBox[{{0, 0, 0}, {1., 0., 0.}}]], 
     Text3DBox[
      StyleBox["\<\"x\"\>",
       StripOnInput->False,
       FormatType->StandardForm,
       FontFamily->"Helvetica",
       FontSize->20], {0.8, -0.044721359549995794`, 0.022360679774997897`},
      FormatType->StandardForm]}, 
    {Arrowheads[Medium], Arrow3DBox[TubeBox[{{0, 0, 0}, {0., 1., 0.}}]], 
     Text3DBox[
      StyleBox["\<\"y\"\>",
       StripOnInput->False,
       FormatType->StandardForm,
       FontFamily->"Helvetica",
       FontSize->20], {0.01436739427831727, 0.8, -0.04789131426105757},
      FormatType->StandardForm]}, 
    {Arrowheads[Medium], Arrow3DBox[TubeBox[{{0, 0, 0}, {0., 0., 1.}}]], 
     Text3DBox[
      StyleBox["\<\"z\"\>",
       StripOnInput->False,
       FormatType->StandardForm,
       FontFamily->"Helvetica",
       FontSize->20], {-0.007417022646512232, 0.04944681764341488, 0.8},
      FormatType->StandardForm]}}, {
    {Arrowheads[Medium], 
     Arrow3DBox[
      TubeBox[{{0, 0, 0}, {0.7146101771427564, 
       0.6337183608619961, -0.2961981327260238}}]], Text3DBox[
      StyleBox["\<\"x\"\>",
       StripOnInput->False,
       FormatType->StandardForm,
       FontFamily->"Helvetica",
       FontSize->14], {0.5869179002976889, 
      0.47382104809411163`, -0.2711475478280223},
      FormatType->StandardForm]}, 
    {Arrowheads[Medium], 
     Arrow3DBox[
      TubeBox[{{0, 0, 0}, {-0.6130920223795969, 0.7712805763691758, 
       0.17101007166283436`}}]], Text3DBox[
      StyleBox["\<\"y\"\>",
       StripOnInput->False,
       FormatType->StandardForm,
       FontFamily->"Helvetica",
       FontSize->14], {-0.4797109594503963, 0.635592601732016, 
      0.09164845883432579},
      FormatType->StandardForm]}, 
    {Arrowheads[Medium], 
     Arrow3DBox[
      TubeBox[{{0, 0, 0}, {0.33682408883346515`, 0.0593911746138847, 
       0.9396926207859084}}]], Text3DBox[
      StyleBox["\<\"z\"\>",
       StripOnInput->False,
       FormatType->StandardForm,
       FontFamily->"Helvetica",
       FontSize->14], {0.26219615111527245`, 0.0969798327683915, 
      0.7512310499284173},
      FormatType->StandardForm]}}, 
   {Opacity[0.5], 
    Polygon3DBox[
     NCache[{{Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
        Rational[-1, 2] Sin[10 Degree], Rational[1, 2] Cos[10 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree], 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree]}, {
       Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[1, 50] Pi], 
        Cos[Rational[1, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[1, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[1, 50] Pi]}, {
       Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[1, 25] Pi], 
        Cos[Rational[1, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[1, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[1, 25] Pi]}, {
       Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[3, 50] Pi], 
        Cos[Rational[3, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[3, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[3, 50] Pi]}, {
       Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[2, 25] Pi], 
        Cos[Rational[2, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[2, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[2, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[2, 25] Pi]}, {(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (-1 + 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (-1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 2] (
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[1, 8] (-1 + 5^Rational[1, 2]) Sin[20 Degree]}, {
       Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[3, 25] Pi], 
        Cos[Rational[3, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[3, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[3, 25] Pi]}, {
       Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[7, 50] Pi], 
        Cos[Rational[7, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[7, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[7, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[7, 50] Pi]}, {
       Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[4, 25] Pi], 
        Cos[Rational[4, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[4, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[4, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[4, 25] Pi]}, {
       Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[9, 50] Pi], 
        Cos[Rational[9, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[9, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[9, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[9, 50] Pi]}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (1 + 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[1, 2] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[-1, 8] 3^Rational[1, 2] (1 + 5^Rational[1, 2]) 
         Sin[20 Degree]}, {
       Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[11, 50] Pi], 
        Cos[Rational[11, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[11, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[11, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[11, 50] Pi]}, {
       Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[6, 25] Pi], 
        Cos[Rational[6, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[6, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[6, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[6, 25] Pi]}, {
       Cos[Rational[6, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[6, 25] Pi], 
        Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[6, 25] Pi], 
        Rational[1, 2] Cos[Rational[6, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[6, 25] Pi]}, {
       Cos[Rational[11, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[11, 50] Pi], 
        Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[11, 50] Pi], 
        Rational[1, 2] Cos[Rational[11, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[11, 50] Pi]}, {(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (1 + 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 2] (
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[1, 8] (1 + 5^Rational[1, 2]) Sin[20 Degree]}, {
       Cos[Rational[9, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[9, 50] Pi], 
        Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[9, 50] Pi], 
        Rational[1, 2] Cos[Rational[9, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[9, 50] Pi]}, {
       Cos[Rational[4, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[4, 25] Pi], 
        Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[4, 25] Pi], 
        Rational[1, 2] Cos[Rational[4, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[4, 25] Pi]}, {
       Cos[Rational[7, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[7, 50] Pi], 
        Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[7, 50] Pi], 
        Rational[1, 2] Cos[Rational[7, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[7, 50] Pi]}, {
       Cos[Rational[3, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[3, 25] Pi], 
        Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 25] Pi], 
        Rational[1, 2] Cos[Rational[3, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 25] Pi]}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (-1 + 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[-1, 8] 3^Rational[1, 2] (-1 + 5^Rational[1, 2]) 
         Sin[20 Degree]}, {
       Cos[Rational[2, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[2, 25] Pi], 
        Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[2, 25] Pi], 
        Rational[1, 2] Cos[Rational[2, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[2, 25] Pi]}, {
       Cos[Rational[3, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[3, 50] Pi], 
        Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 50] Pi], 
        Rational[1, 2] Cos[Rational[3, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 50] Pi]}, {
       Cos[Rational[1, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[1, 25] Pi], 
        Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 25] Pi], 
        Rational[1, 2] Cos[Rational[1, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 25] Pi]}, {
       Cos[Rational[1, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[1, 50] Pi], 
        Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 50] Pi], 
        Rational[1, 2] Cos[Rational[1, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 50] Pi]}, {
       Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree], 
        Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
        Rational[-1, 2] Cos[20 Degree] Sin[10 Degree], Rational[1, 2] 
        Sin[20 Degree]}, {
       Cos[Rational[1, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[1, 50] Pi], 
        Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 50] Pi], 
        Rational[1, 2] Cos[Rational[1, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 50] Pi]}, {
       Cos[Rational[1, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[1, 25] Pi], 
        Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 25] Pi], 
        Rational[1, 2] Cos[Rational[1, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 25] Pi]}, {
       Cos[Rational[3, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[3, 50] Pi], 
        Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 50] Pi], 
        Rational[1, 2] Cos[Rational[3, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 50] Pi]}, {
       Cos[Rational[2, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[2, 25] Pi], 
        Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[2, 25] Pi], 
        Rational[1, 2] Cos[Rational[2, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[2, 25] Pi]}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (1 - 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 8] 3^Rational[1, 2] (1 - 5^Rational[1, 2]) 
         Sin[20 Degree] + 
        Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree]}, {
       Cos[Rational[3, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[3, 25] Pi], 
        Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 25] Pi], 
        Rational[1, 2] Cos[Rational[3, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 25] Pi]}, {
       Cos[Rational[7, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[7, 50] Pi], 
        Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[7, 50] Pi], 
        Rational[1, 2] Cos[Rational[7, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[7, 50] Pi]}, {
       Cos[Rational[4, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[4, 25] Pi], 
        Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[4, 25] Pi], 
        Rational[1, 2] Cos[Rational[4, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[4, 25] Pi]}, {
       Cos[Rational[9, 50] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[9, 50] Pi], 
        Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[9, 50] Pi], 
        Rational[1, 2] Cos[Rational[9, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[9, 50] Pi]}, {-(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (1 + 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[
          1, 2] (3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[1, 8] (1 + 5^Rational[1, 2]) Sin[20 Degree]}, {
       Cos[Rational[11, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[11, 50] Pi], 
        Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[11, 50] Pi], 
        Rational[1, 2] Cos[Rational[11, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[11, 50] Pi]}, {
       Cos[Rational[6, 25] Pi] (Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) Sin[Rational[6, 25] Pi], 
        Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[6, 25] Pi], 
        Rational[1, 2] Cos[Rational[6, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[6, 25] Pi]}, {-
         Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[6, 25] Pi], -
         Cos[Rational[6, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[6, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[6, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[6, 25] Pi]}, {-
         Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[11, 50] Pi], -
         Cos[Rational[11, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[11, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[11, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[11, 50] Pi]}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (-1 - 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 8] 3^Rational[1, 2] (-1 - 5^Rational[1, 2]) 
         Sin[20 Degree] + 
        Rational[1, 2] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree]}, {-
         Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[9, 50] Pi], -
         Cos[Rational[9, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[9, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[9, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[9, 50] Pi]}, {-
         Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[4, 25] Pi], -
         Cos[Rational[4, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[4, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[4, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[4, 25] Pi]}, {-
         Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[7, 50] Pi], -
         Cos[Rational[7, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[7, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[7, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[7, 50] Pi]}, {-
         Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[3, 25] Pi], -
         Cos[Rational[3, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[3, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 25] Pi]}, {-(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (-1 + 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (-1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[1, 2] (3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[1, 8] (-1 + 5^Rational[1, 2]) Sin[20 Degree]}, {-
         Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[2, 25] Pi], -
         Cos[Rational[2, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[2, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[2, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[2, 25] Pi]}, {-
         Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[3, 50] Pi], -
         Cos[Rational[3, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[3, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[3, 50] Pi]}, {-
         Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[1, 25] Pi], -
         Cos[Rational[1, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[1, 25] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[1, 25] Pi]}, {-
         Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
         Sin[Rational[1, 50] Pi], -
         Cos[Rational[1, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[1, 50] Pi] 
         Sin[20 Degree] + 
        Rational[1, 2] Sin[20 Degree] Sin[Rational[1, 50] Pi]}, {
       Rational[-1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
        Rational[1, 2] Sin[10 Degree], Rational[-1, 2] Cos[10 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree], 
        Rational[1, 2] 3^Rational[1, 2] 
        Sin[20 Degree]}, {-
         Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[1, 50] Pi], -
         Cos[Rational[1, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[1, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[1, 50] Pi]}, {-
         Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[1, 25] Pi], -
         Cos[Rational[1, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[1, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[1, 25] Pi]}, {-
         Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[3, 50] Pi], -
         Cos[Rational[3, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[3, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[3, 50] Pi]}, {-
         Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[2, 25] Pi], -
         Cos[Rational[2, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[2, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[2, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] 
         Sin[Rational[2, 25] Pi]}, {-(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (1 - 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[1, 8] (1 - 5^Rational[1, 2]) Sin[20 Degree] + 
        Rational[1, 2] (3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree]}, {-
         Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[3, 25] Pi], -
         Cos[Rational[3, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[3, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[3, 25] Pi]}, {-
         Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[7, 50] Pi], -
         Cos[Rational[7, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[7, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[7, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[7, 50] Pi]}, {-
         Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[4, 25] Pi], -
         Cos[Rational[4, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[4, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[4, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[4, 25] Pi]}, {-
         Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[9, 50] Pi], -
         Cos[Rational[9, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[9, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[9, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[9, 50] Pi]}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] 
          Sin[10 Degree]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (-1 - 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 8] 3^Rational[1, 2] (-1 - 5^Rational[1, 2]) 
         Sin[20 Degree] + 
        Rational[-1, 2] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree]}, {-
         Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[11, 50] Pi], -
         Cos[Rational[11, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[11, 50] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[11, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[11, 50] Pi]}, {-
         Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[6, 25] Pi], -
         Cos[Rational[6, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[6, 25] Pi], 
        Rational[1, 2] 3^Rational[1, 2] Cos[Rational[6, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[6, 25] Pi]}, {-
         Cos[Rational[6, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[6, 25] Pi], -
         Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[6, 25] Pi], 
        Rational[-1, 2] Cos[Rational[6, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[6, 25] Pi]}, {-
         Cos[Rational[11, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[11, 50] Pi], -
         Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[11, 50] Pi], 
        Rational[-1, 2] Cos[Rational[11, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[11, 50] Pi]}, {-(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (-1 - 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (-1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[1, 8] (-1 - 5^Rational[1, 2]) Sin[20 Degree] + 
        Rational[
          1, 2] (3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree]}, {-
         Cos[Rational[9, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[9, 50] Pi], -
         Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[9, 50] Pi], 
        Rational[-1, 2] Cos[Rational[9, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[9, 50] Pi]}, {-
         Cos[Rational[4, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[4, 25] Pi], -
         Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[4, 25] Pi], 
        Rational[-1, 2] Cos[Rational[4, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[4, 25] Pi]}, {-
         Cos[Rational[7, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[7, 50] Pi], -
         Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[7, 50] Pi], 
        Rational[-1, 2] Cos[Rational[7, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[7, 50] Pi]}, {-
         Cos[Rational[3, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[3, 25] Pi], -
         Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 25] Pi], 
        Rational[-1, 2] Cos[Rational[3, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 25] Pi]}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] 
          Sin[10 Degree]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (1 - 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 8] 3^Rational[1, 2] (1 - 5^Rational[1, 2]) 
         Sin[20 Degree] + 
        Rational[-1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree]}, {-
         Cos[Rational[2, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[2, 25] Pi], -
         Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[2, 25] Pi], 
        Rational[-1, 2] Cos[Rational[2, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[2, 25] Pi]}, {-
         Cos[Rational[3, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[3, 50] Pi], -
         Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 50] Pi], 
        Rational[-1, 2] Cos[Rational[3, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 50] Pi]}, {-
         Cos[Rational[1, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[1, 25] Pi], -
         Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 25] Pi], 
        Rational[-1, 2] Cos[Rational[1, 25] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 25] Pi]}, {-
         Cos[Rational[1, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] Sin[10 Degree]) 
        Sin[Rational[1, 50] Pi], -
         Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] Cos[10 Degree] + 
         Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 50] Pi], 
        Rational[-1, 2] Cos[Rational[1, 50] Pi] Sin[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 50] Pi]}, {
       Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Sin[10 Degree], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
        Rational[1, 2] Cos[20 Degree] Sin[10 Degree], Rational[-1, 2] 
        Sin[20 Degree]}, {-
         Cos[Rational[1, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[1, 50] Pi], -
         Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 50] Pi], 
        Rational[-1, 2] Cos[Rational[1, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 50] Pi]}, {-
         Cos[Rational[1, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[1, 25] Pi], -
         Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[1, 25] Pi], 
        Rational[-1, 2] Cos[Rational[1, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[1, 25] Pi]}, {-
         Cos[Rational[3, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[3, 50] Pi], -
         Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 50] Pi], 
        Rational[-1, 2] Cos[Rational[3, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 50] Pi]}, {-
         Cos[Rational[2, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[2, 25] Pi], -
         Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[2, 25] Pi], 
        Rational[-1, 2] Cos[Rational[2, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[2, 25] Pi]}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] 
          Sin[10 Degree]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (-1 + 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[-1, 8] 3^Rational[1, 2] (-1 + 5^Rational[1, 2]) 
         Sin[20 Degree]}, {-
         Cos[Rational[3, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[3, 25] Pi], -
         Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[3, 25] Pi], 
        Rational[-1, 2] Cos[Rational[3, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[3, 25] Pi]}, {-
         Cos[Rational[7, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[7, 50] Pi], -
         Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[7, 50] Pi], 
        Rational[-1, 2] Cos[Rational[7, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[7, 50] Pi]}, {-
         Cos[Rational[4, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[4, 25] Pi], -
         Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[4, 25] Pi], 
        Rational[-1, 2] Cos[Rational[4, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[4, 25] Pi]}, {-
         Cos[Rational[9, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[9, 50] Pi], -
         Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[9, 50] Pi], 
        Rational[-1, 2] Cos[Rational[9, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[9, 50] Pi]}, {(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (-1 - 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (-1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[1, 8] (-1 - 5^Rational[1, 2]) Sin[20 Degree] + 
        Rational[-1, 2] (
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree]}, {-
         Cos[Rational[11, 50] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[11, 50] Pi], -
         Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[11, 50] Pi], 
        Rational[-1, 2] Cos[Rational[11, 50] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[11, 50] Pi]}, {-
         Cos[Rational[6, 25] Pi] (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) + (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) Sin[Rational[6, 25] Pi], -
         Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) 
         Sin[Rational[6, 25] Pi], 
        Rational[-1, 2] Cos[Rational[6, 25] Pi] Sin[20 Degree] + 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree] 
         Sin[Rational[6, 25] Pi]}, {
       Cos[Rational[6, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[6, 25] Pi], 
        Cos[Rational[6, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[6, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[6, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[6, 25] Pi]}, {
       Cos[Rational[11, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[11, 50] Pi], 
        Cos[Rational[11, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[11, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[11, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[11, 50] Pi]}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] 
          Sin[10 Degree]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + 
        Rational[1, 4] (1 + 5^Rational[1, 2]) (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[-1, 2] (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
          Rational[1, 2] Sin[20 Degree] + 
        Rational[-1, 8] 3^Rational[1, 2] (1 + 5^Rational[1, 2]) 
         Sin[20 Degree]}, {
       Cos[Rational[9, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[9, 50] Pi], 
        Cos[Rational[9, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[9, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[9, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[9, 50] Pi]}, {
       Cos[Rational[4, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[4, 25] Pi], 
        Cos[Rational[4, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[4, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[4, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[4, 25] Pi]}, {
       Cos[Rational[7, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[7, 50] Pi], 
        Cos[Rational[7, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[7, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[7, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[7, 50] Pi]}, {
       Cos[Rational[3, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[3, 25] Pi], 
        Cos[Rational[3, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[3, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] 
         Sin[Rational[3, 25] Pi]}, {(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) + 
        Rational[1, 4] (1 - 5^Rational[1, 2]) (
          Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]), 
        Rational[1, 4] (1 - 5^Rational[1, 2]) (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
          Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) + (Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] (
          Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]), 
        Rational[1, 8] (1 - 5^Rational[1, 2]) Sin[20 Degree] + 
        Rational[-1, 2] (
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
          Rational[1, 2] Sin[20 Degree]}, {
       Cos[Rational[2, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[2, 25] Pi], 
        Cos[Rational[2, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[2, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[2, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[2, 25] Pi]}, {
       Cos[Rational[3, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[3, 50] Pi], 
        Cos[Rational[3, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[3, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[3, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[3, 50] Pi]}, {
       Cos[Rational[1, 25] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[1, 25] Pi], 
        Cos[Rational[1, 25] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 25] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[1, 25] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[1, 25] Pi]}, {
       Cos[Rational[1, 50] Pi] (
          Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
          Rational[-1, 2] Sin[10 Degree]) - (
         Rational[-1, 2] Cos[10 Degree] Cos[20 Degree] + 
         Rational[-1, 2] 3^Rational[1, 2] Sin[10 Degree]) 
        Sin[Rational[1, 50] Pi], 
        Cos[Rational[1, 50] Pi] (Rational[1, 2] Cos[10 Degree] + 
          Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree]) - (
         Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] + 
         Rational[-1, 2] Cos[20 Degree] Sin[10 Degree]) 
        Sin[Rational[1, 50] Pi], 
        Rational[-1, 2] 3^Rational[1, 2] Cos[Rational[1, 50] Pi] 
         Sin[20 Degree] + 
        Rational[-1, 2] Sin[20 Degree] Sin[Rational[1, 50] Pi]}, {
       Rational[1, 2] 3^Rational[1, 2] Cos[10 Degree] Cos[20 Degree] + 
        Rational[-1, 2] Sin[10 Degree], Rational[1, 2] Cos[10 Degree] + 
        Rational[1, 2] 3^Rational[1, 2] Cos[20 Degree] Sin[10 Degree], 
        Rational[-1, 2] 3^Rational[1, 2] Sin[20 Degree]}}, CompressedData["
1:eJx11ltcFAQexfFRWTRYQ8tbZRpKKxBeRsFWyk55SyuQ2okUSKUPg6GiMLmx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      "]]]}, 
   {Opacity[0.5], 
    Polygon3DBox[
     NCache[{{1, 0, 0}, {
       Cos[Rational[1, 50] Pi], Sin[Rational[1, 50] Pi], 0}, {
       Cos[Rational[1, 25] Pi], Sin[Rational[1, 25] Pi], 0}, {
       Cos[Rational[3, 50] Pi], Sin[Rational[3, 50] Pi], 0}, {
       Cos[Rational[2, 25] Pi], Sin[Rational[2, 25] Pi], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
       Cos[Rational[3, 25] Pi], Sin[Rational[3, 25] Pi], 0}, {
       Cos[Rational[7, 50] Pi], Sin[Rational[7, 50] Pi], 0}, {
       Cos[Rational[4, 25] Pi], Sin[Rational[4, 25] Pi], 0}, {
       Cos[Rational[9, 50] Pi], Sin[Rational[9, 50] Pi], 0}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[11, 50] Pi], Sin[Rational[11, 50] Pi], 0}, {
       Cos[Rational[6, 25] Pi], Sin[Rational[6, 25] Pi], 0}, {
       Sin[Rational[6, 25] Pi], Cos[Rational[6, 25] Pi], 0}, {
       Sin[Rational[11, 50] Pi], Cos[Rational[11, 50] Pi], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Sin[Rational[9, 50] Pi], Cos[Rational[9, 50] Pi], 0}, {
       Sin[Rational[4, 25] Pi], Cos[Rational[4, 25] Pi], 0}, {
       Sin[Rational[7, 50] Pi], Cos[Rational[7, 50] Pi], 0}, {
       Sin[Rational[3, 25] Pi], Cos[Rational[3, 25] Pi], 0}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[2, 25] Pi], Cos[Rational[2, 25] Pi], 0}, {
       Sin[Rational[3, 50] Pi], Cos[Rational[3, 50] Pi], 0}, {
       Sin[Rational[1, 25] Pi], Cos[Rational[1, 25] Pi], 0}, {
       Sin[Rational[1, 50] Pi], Cos[Rational[1, 50] Pi], 0}, {0, 1, 
       0}, {-Sin[Rational[1, 50] Pi], Cos[Rational[1, 50] Pi], 0}, {-
        Sin[Rational[1, 25] Pi], Cos[Rational[1, 25] Pi], 0}, {-
        Sin[Rational[3, 50] Pi], Cos[Rational[3, 50] Pi], 0}, {-
        Sin[Rational[2, 25] Pi], Cos[Rational[2, 25] Pi], 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Sin[Rational[3, 25] Pi], Cos[Rational[3, 25] Pi], 0}, {-
        Sin[Rational[7, 50] Pi], Cos[Rational[7, 50] Pi], 0}, {-
        Sin[Rational[4, 25] Pi], Cos[Rational[4, 25] Pi], 0}, {-
        Sin[Rational[9, 50] Pi], Cos[Rational[9, 50] Pi], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {-
        Sin[Rational[11, 50] Pi], Cos[Rational[11, 50] Pi], 0}, {-
        Sin[Rational[6, 25] Pi], Cos[Rational[6, 25] Pi], 0}, {-
        Cos[Rational[6, 25] Pi], Sin[Rational[6, 25] Pi], 0}, {-
        Cos[Rational[11, 50] Pi], Sin[Rational[11, 50] Pi], 0}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[9, 50] Pi], Sin[Rational[9, 50] Pi], 0}, {-
        Cos[Rational[4, 25] Pi], Sin[Rational[4, 25] Pi], 0}, {-
        Cos[Rational[7, 50] Pi], Sin[Rational[7, 50] Pi], 0}, {-
        Cos[Rational[3, 25] Pi], Sin[Rational[3, 25] Pi], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-
        Cos[Rational[2, 25] Pi], Sin[Rational[2, 25] Pi], 0}, {-
        Cos[Rational[3, 50] Pi], Sin[Rational[3, 50] Pi], 0}, {-
        Cos[Rational[1, 25] Pi], Sin[Rational[1, 25] Pi], 0}, {-
        Cos[Rational[1, 50] Pi], Sin[Rational[1, 50] Pi], 0}, {-1, 0, 
       0}, {-Cos[Rational[1, 50] Pi], -Sin[Rational[1, 50] Pi], 0}, {-
        Cos[Rational[1, 25] Pi], -Sin[Rational[1, 25] Pi], 0}, {-
        Cos[Rational[3, 50] Pi], -Sin[Rational[3, 50] Pi], 0}, {-
        Cos[Rational[2, 25] Pi], -Sin[Rational[2, 25] Pi], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {-
        Cos[Rational[3, 25] Pi], -Sin[Rational[3, 25] Pi], 0}, {-
        Cos[Rational[7, 50] Pi], -Sin[Rational[7, 50] Pi], 0}, {-
        Cos[Rational[4, 25] Pi], -Sin[Rational[4, 25] Pi], 0}, {-
        Cos[Rational[9, 50] Pi], -Sin[Rational[9, 50] Pi], 0}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[11, 50] Pi], -Sin[Rational[11, 50] Pi], 0}, {-
        Cos[Rational[6, 25] Pi], -Sin[Rational[6, 25] Pi], 0}, {-
        Sin[Rational[6, 25] Pi], -Cos[Rational[6, 25] Pi], 0}, {-
        Sin[Rational[11, 50] Pi], -Cos[Rational[11, 50] Pi], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {-
        Sin[Rational[9, 50] Pi], -Cos[Rational[9, 50] Pi], 0}, {-
        Sin[Rational[4, 25] Pi], -Cos[Rational[4, 25] Pi], 0}, {-
        Sin[Rational[7, 50] Pi], -Cos[Rational[7, 50] Pi], 0}, {-
        Sin[Rational[3, 25] Pi], -Cos[Rational[3, 25] Pi], 0}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}, {-Sin[Rational[2, 25] Pi], -
        Cos[Rational[2, 25] Pi], 0}, {-Sin[Rational[3, 50] Pi], -
        Cos[Rational[3, 50] Pi], 0}, {-Sin[Rational[1, 25] Pi], -
        Cos[Rational[1, 25] Pi], 0}, {-Sin[Rational[1, 50] Pi], -
        Cos[Rational[1, 50] Pi], 0}, {0, -1, 0}, {
       Sin[Rational[1, 50] Pi], -Cos[Rational[1, 50] Pi], 0}, {
       Sin[Rational[1, 25] Pi], -Cos[Rational[1, 25] Pi], 0}, {
       Sin[Rational[3, 50] Pi], -Cos[Rational[3, 50] Pi], 0}, {
       Sin[Rational[2, 25] Pi], -Cos[Rational[2, 25] Pi], 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[3, 25] Pi], -Cos[Rational[3, 25] Pi], 0}, {
       Sin[Rational[7, 50] Pi], -Cos[Rational[7, 50] Pi], 0}, {
       Sin[Rational[4, 25] Pi], -Cos[Rational[4, 25] Pi], 0}, {
       Sin[Rational[9, 50] Pi], -Cos[Rational[9, 50] Pi], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Sin[Rational[11, 50] Pi], -Cos[Rational[11, 50] Pi], 0}, {
       Sin[Rational[6, 25] Pi], -Cos[Rational[6, 25] Pi], 0}, {
       Cos[Rational[6, 25] Pi], -Sin[Rational[6, 25] Pi], 0}, {
       Cos[Rational[11, 50] Pi], -Sin[Rational[11, 50] Pi], 0}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[9, 50] Pi], -Sin[Rational[9, 50] Pi], 0}, {
       Cos[Rational[4, 25] Pi], -Sin[Rational[4, 25] Pi], 0}, {
       Cos[Rational[7, 50] Pi], -Sin[Rational[7, 50] Pi], 0}, {
       Cos[Rational[3, 25] Pi], -Sin[Rational[3, 25] Pi], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
       Cos[Rational[2, 25] Pi], -Sin[Rational[2, 25] Pi], 0}, {
       Cos[Rational[3, 50] Pi], -Sin[Rational[3, 50] Pi], 0}, {
       Cos[Rational[1, 25] Pi], -Sin[Rational[1, 25] Pi], 0}, {
       Cos[Rational[1, 50] Pi], -Sin[Rational[1, 50] Pi], 0}, {1, 0, 0}}, {{1,
        0, 0}, {0.9980267284282716, 0.06279051952931337, 0}, {
       0.9921147013144779, 0.12533323356430426`, 0}, {
       0.9822872507286887, 0.1873813145857246, 0}, {
       0.9685831611286311, 0.2486898871648548, 0}, {
       0.9510565162951535, 0.30901699437494745`, 0}, {
       0.9297764858882515, 0.3681245526846779, 0}, {
       0.9048270524660195, 0.4257792915650727, 0}, {
       0.8763066800438636, 0.4817536741017153, 0}, {
       0.8443279255020151, 0.5358267949789967, 0}, {
       0.8090169943749475, 0.5877852522924731, 0}, {
       0.7705132427757893, 0.6374239897486896, 0}, {
       0.7289686274214116, 0.6845471059286886, 0}, {
       0.6845471059286886, 0.7289686274214116, 0}, {
       0.6374239897486896, 0.7705132427757893, 0}, {
       0.5877852522924731, 0.8090169943749475, 0}, {
       0.5358267949789967, 0.8443279255020151, 0}, {
       0.4817536741017153, 0.8763066800438636, 0}, {
       0.4257792915650727, 0.9048270524660195, 0}, {
       0.3681245526846779, 0.9297764858882515, 0}, {
       0.30901699437494745`, 0.9510565162951535, 0}, {
       0.2486898871648548, 0.9685831611286311, 0}, {
       0.1873813145857246, 0.9822872507286887, 0}, {
       0.12533323356430426`, 0.9921147013144779, 0}, {
       0.06279051952931337, 0.9980267284282716, 0}, {0, 1, 
       0}, {-0.06279051952931337, 0.9980267284282716, 
        0}, {-0.12533323356430426`, 0.9921147013144779, 
        0}, {-0.1873813145857246, 0.9822872507286887, 
        0}, {-0.2486898871648548, 0.9685831611286311, 
        0}, {-0.30901699437494745`, 0.9510565162951535, 
        0}, {-0.3681245526846779, 0.9297764858882515, 
        0}, {-0.4257792915650727, 0.9048270524660195, 
        0}, {-0.4817536741017153, 0.8763066800438636, 
        0}, {-0.5358267949789967, 0.8443279255020151, 
        0}, {-0.5877852522924731, 0.8090169943749475, 
        0}, {-0.6374239897486896, 0.7705132427757893, 
        0}, {-0.6845471059286886, 0.7289686274214116, 
        0}, {-0.7289686274214116, 0.6845471059286886, 
        0}, {-0.7705132427757893, 0.6374239897486896, 
        0}, {-0.8090169943749475, 0.5877852522924731, 
        0}, {-0.8443279255020151, 0.5358267949789967, 
        0}, {-0.8763066800438636, 0.4817536741017153, 
        0}, {-0.9048270524660195, 0.4257792915650727, 
        0}, {-0.9297764858882515, 0.3681245526846779, 
        0}, {-0.9510565162951535, 0.30901699437494745`, 
        0}, {-0.9685831611286311, 0.2486898871648548, 
        0}, {-0.9822872507286887, 0.1873813145857246, 
        0}, {-0.9921147013144779, 0.12533323356430426`, 
        0}, {-0.9980267284282716, 0.06279051952931337, 0}, {-1, 0, 
       0}, {-0.9980267284282716, -0.06279051952931337, 
        0}, {-0.9921147013144779, -0.12533323356430426`, 
        0}, {-0.9822872507286887, -0.1873813145857246, 
        0}, {-0.9685831611286311, -0.2486898871648548, 
        0}, {-0.9510565162951535, -0.30901699437494745`, 
        0}, {-0.9297764858882515, -0.3681245526846779, 
        0}, {-0.9048270524660195, -0.4257792915650727, 
        0}, {-0.8763066800438636, -0.4817536741017153, 
        0}, {-0.8443279255020151, -0.5358267949789967, 
        0}, {-0.8090169943749475, -0.5877852522924731, 
        0}, {-0.7705132427757893, -0.6374239897486896, 
        0}, {-0.7289686274214116, -0.6845471059286886, 
        0}, {-0.6845471059286886, -0.7289686274214116, 
        0}, {-0.6374239897486896, -0.7705132427757893, 
        0}, {-0.5877852522924731, -0.8090169943749475, 
        0}, {-0.5358267949789967, -0.8443279255020151, 
        0}, {-0.4817536741017153, -0.8763066800438636, 
        0}, {-0.4257792915650727, -0.9048270524660195, 
        0}, {-0.3681245526846779, -0.9297764858882515, 
        0}, {-0.30901699437494745`, -0.9510565162951535, 
        0}, {-0.2486898871648548, -0.9685831611286311, 
        0}, {-0.1873813145857246, -0.9822872507286887, 
        0}, {-0.12533323356430426`, -0.9921147013144779, 
        0}, {-0.06279051952931337, -0.9980267284282716, 0}, {0, -1, 0}, {
       0.06279051952931337, -0.9980267284282716, 0}, {
       0.12533323356430426`, -0.9921147013144779, 0}, {
       0.1873813145857246, -0.9822872507286887, 0}, {
       0.2486898871648548, -0.9685831611286311, 0}, {
       0.30901699437494745`, -0.9510565162951535, 0}, {
       0.3681245526846779, -0.9297764858882515, 0}, {
       0.4257792915650727, -0.9048270524660195, 0}, {
       0.4817536741017153, -0.8763066800438636, 0}, {
       0.5358267949789967, -0.8443279255020151, 0}, {
       0.5877852522924731, -0.8090169943749475, 0}, {
       0.6374239897486896, -0.7705132427757893, 0}, {
       0.6845471059286886, -0.7289686274214116, 0}, {
       0.7289686274214116, -0.6845471059286886, 0}, {
       0.7705132427757893, -0.6374239897486896, 0}, {
       0.8090169943749475, -0.5877852522924731, 0}, {
       0.8443279255020151, -0.5358267949789967, 0}, {
       0.8763066800438636, -0.4817536741017153, 0}, {
       0.9048270524660195, -0.4257792915650727, 0}, {
       0.9297764858882515, -0.3681245526846779, 0}, {
       0.9510565162951535, -0.30901699437494745`, 0}, {
       0.9685831611286311, -0.2486898871648548, 0}, {
       0.9822872507286887, -0.1873813145857246, 0}, {
       0.9921147013144779, -0.12533323356430426`, 0}, {
       0.9980267284282716, -0.06279051952931337, 0}, {1, 0, 0}}]]}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{460.90260864054414`, 519.7761166157787},
  LabelStyle->Directive[Medium, FontFamily -> "Helvetica"],
  PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}, {-1.1, 1.1}},
  ViewPoint->{10, 1.5, 3.},
  ViewVertical->{0.183887966632494, 0.022701386605362472`, 
   0.9826850272462488}]], "Output",
 CellChangeTimes->{{3.604056630865645*^9, 3.6040566485297213`*^9}, {
   3.604056681838908*^9, 3.6040566949618177`*^9}, {3.604056725851665*^9, 
   3.6040567904317293`*^9}, 3.604056831037335*^9, 3.604056873314571*^9, 
   3.60405697549854*^9, 3.604057051942294*^9, {3.6040571003126783`*^9, 
   3.6040571451973343`*^9}, 3.6040572216777678`*^9, 3.604059095820827*^9, 
   3.604847139050247*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}], "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "20", ",", "30"}], "}"}], "\[Degree]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Manipulate", "[", 
   RowBox[{
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z"}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{"ex", ",", "ey", ",", "ez"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"RotateEuler", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
          "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{"X", ",", "Y", ",", "Z"}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"xyplane", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
          RowBox[{"Polygon", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", " ", 
               RowBox[{"Cos", "[", "\[Phi]", "]"}]}], "+", 
              RowBox[{"y", " ", 
               RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Phi]", ",", "0", ",", 
               RowBox[{"2", "\[Pi]"}], ",", 
               RowBox[{"2", 
                RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"XYplane", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
          RowBox[{"Polygon", "[", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"X", " ", 
               RowBox[{"Cos", "[", "\[Phi]", "]"}]}], "+", 
              RowBox[{"Y", " ", 
               RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"\[Phi]", ",", "0", ",", 
               RowBox[{"2", "\[Pi]"}], ",", 
               RowBox[{"2", 
                RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Axes3D", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "Z"}], "}"}], ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Axes3D", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", "xyplane", ",", "\[IndentingNewLine]", 
        "XYplane"}], "\[IndentingNewLine]", " ", "]"}]}], ")"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "0", ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"\"\<\[Alpha] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"\[Alpha]", "/", "\[Degree]"}], "]"}], "<>", 
          "\"\<\[Degree]\>\""}], "]"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"-", "180"}], "\[Degree]"}], ",", 
      RowBox[{"180", "\[Degree]"}], ",", 
      RowBox[{"1", "\[Degree]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Beta]", ",", "0", ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"\"\<\[Beta] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"\[Beta]", "/", "\[Degree]"}], "]"}], "<>", 
          "\"\<\[Degree]\>\""}], "]"}]}], "}"}], ",", "0", ",", 
      RowBox[{"180", "\[Degree]"}], ",", 
      RowBox[{"1", "\[Degree]"}]}], "}"}], ",", "\[IndentingNewLine]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Gamma]", ",", "0", ",", 
        RowBox[{"Dynamic", "[", 
         RowBox[{"\"\<\[Gamma] = \>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{"\[Gamma]", "/", "\[Degree]"}], "]"}], "<>", 
          "\"\<\[Degree]\>\""}], "]"}]}], "}"}], ",", 
      RowBox[{
       RowBox[{"-", "180"}], "\[Degree]"}], ",", 
      RowBox[{"180", "\[Degree]"}], ",", 
      RowBox[{"1", "\[Degree]"}]}], "}"}]}], "\[IndentingNewLine]", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.604056611525753*^9, 3.604056789904429*^9}, {
   3.6040568294813843`*^9, 3.604056872279793*^9}, {3.604056915287949*^9, 
   3.604057051315474*^9}, {3.604057086048457*^9, 3.604057355926938*^9}, {
   3.604847777494815*^9, 3.604847780227208*^9}, 3.6048478141341457`*^9, {
   3.604847968827436*^9, 3.604847973698004*^9}, {3.604848008407934*^9, 
   3.604848075735325*^9}, {3.60484816417741*^9, 3.6048481818339567`*^9}, {
   3.6048482431819143`*^9, 3.60484825852627*^9}, {3.604848375873622*^9, 
   3.604848420755937*^9}, {3.6048484857167263`*^9, 3.6048484971665*^9}, {
   3.6048485393822203`*^9, 3.604848574071488*^9}, {3.604848663487393*^9, 
   3.604848893560309*^9}, {3.604848969659668*^9, 3.604849027395306*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = (-57) 
    Degree, $CellContext`\[Beta]$$ = 25 
    Degree, $CellContext`\[Gamma]$$ = (-50) Degree, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Alpha]$$], 0, 
       Dynamic[
        StringJoin["\[Alpha] = ", 
         ToString[$CellContext`\[Alpha]$$/Degree], "\[Degree]"]]}, (-180) 
      Degree, 180 Degree, Degree}, {{
       Hold[$CellContext`\[Beta]$$], 0, 
       Dynamic[
        StringJoin["\[Beta] = ", 
         ToString[$CellContext`\[Beta]$$/Degree], "\[Degree]"]]}, 0, 180 
      Degree, Degree}, {{
       Hold[$CellContext`\[Gamma]$$], 0, 
       Dynamic[
        StringJoin["\[Gamma] = ", 
         ToString[$CellContext`\[Gamma]$$/Degree], "\[Degree]"]]}, (-180) 
      Degree, 180 Degree, Degree}}, Typeset`size$$ = {360., {198., 202.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Alpha]$25541$$ = 0, $CellContext`\[Beta]$25542$$ = 
    0, $CellContext`\[Gamma]$25543$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Alpha]$$ = 0, $CellContext`\[Beta]$$ = 
        0, $CellContext`\[Gamma]$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`\[Alpha]$$, $CellContext`\[Alpha]$25541$$, 0], 
        Hold[$CellContext`\[Beta]$$, $CellContext`\[Beta]$25542$$, 0], 
        Hold[$CellContext`\[Gamma]$$, $CellContext`\[Gamma]$25543$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ({$CellContext`X, $CellContext`Y, $CellContext`Z} = {
         General`General3D`ex, General`General3D`ey, 
          General`General3D`ez}; {$CellContext`x, $CellContext`y, \
$CellContext`z} = 
        Map[Rotations`Euler`RotateEuler[#, {$CellContext`\[Alpha]$$, \
$CellContext`\[Beta]$$, $CellContext`\[Gamma]$$}]& , {$CellContext`X, \
$CellContext`Y, $CellContext`Z}]; $CellContext`xyplane = Graphics3D[{
           Opacity[0.5], 
           Polygon[
            
            Table[$CellContext`x Cos[$CellContext`\[Phi]] + $CellContext`y 
              Sin[$CellContext`\[Phi]], {$CellContext`\[Phi], 0, 2 Pi, 
              2 (Pi/100)}]]}]; $CellContext`XYplane = Graphics3D[{
           Opacity[0.5], 
           Polygon[
            
            Table[$CellContext`X Cos[$CellContext`\[Phi]] + $CellContext`Y 
              Sin[$CellContext`\[Phi]], {$CellContext`\[Phi], 0, 2 Pi, 
              2 (Pi/100)}]]}]; Show[
         Graphics3D`Visualization`Axes3D[{$CellContext`X, $CellContext`Y, \
$CellContext`Z}, FontSize -> 20], 
         Graphics3D`Visualization`Axes3D[{$CellContext`x, $CellContext`y, \
$CellContext`z}], $CellContext`xyplane, $CellContext`XYplane]), 
      "Specifications" :> {{{$CellContext`\[Alpha]$$, 0, 
          Dynamic[
           StringJoin["\[Alpha] = ", 
            ToString[$CellContext`\[Alpha]$$/Degree], "\[Degree]"]]}, (-180) 
         Degree, 180 Degree, Degree}, {{$CellContext`\[Beta]$$, 0, 
          Dynamic[
           StringJoin["\[Beta] = ", 
            ToString[$CellContext`\[Beta]$$/Degree], "\[Degree]"]]}, 0, 180 
         Degree, Degree}, {{$CellContext`\[Gamma]$$, 0, 
          Dynamic[
           StringJoin["\[Gamma] = ", 
            ToString[$CellContext`\[Gamma]$$/Degree], "\[Degree]"]]}, (-180) 
         Degree, 180 Degree, Degree}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {270., 275.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.604056630865645*^9, 3.6040566485297213`*^9}, {
   3.604056681838908*^9, 3.6040566949618177`*^9}, {3.604056725851665*^9, 
   3.6040567904317293`*^9}, 3.604056831037335*^9, 3.604056873314571*^9, 
   3.60405697549854*^9, 3.604057051942294*^9, {3.6040571003126783`*^9, 
   3.6040571451973343`*^9}, 3.6040572216777678`*^9, 3.60405735708701*^9, 
   3.60405909592206*^9, {3.604847770589715*^9, 3.60484778117132*^9}, 
   3.604847814896722*^9, 3.604847974669842*^9, {3.6048480102740097`*^9, 
   3.604848076361577*^9}, {3.604848166452746*^9, 3.6048481824268713`*^9}, {
   3.604848247142454*^9, 3.6048482592539787`*^9}, 3.604848421791049*^9, {
   3.604848491049102*^9, 3.6048484978960867`*^9}, {3.604848545924356*^9, 
   3.60484857539303*^9}, {3.6048486775282297`*^9, 3.604848693528322*^9}, {
   3.6048487254958878`*^9, 3.6048488944391003`*^9}, {3.60484900176637*^9, 
   3.6048490282824993`*^9}}]
}, Open  ]]
},
WindowSize->{740, 867},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->FrontEnd`FileName[{$RootDirectory, "Users", "mhl", 
   "Library", "Mathematica", "SystemFiles", "FrontEnd", "StyleSheets"}, 
  "mhl-default.nb", CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 144, 2, 28, "Input"],
Cell[726, 26, 409, 9, 60, "Message"],
Cell[1138, 37, 196, 5, 33, "Print"]
}, Open  ]],
Cell[1349, 45, 733, 19, 80, "Input"],
Cell[CellGroupData[{
Cell[2107, 68, 2935, 85, 301, "Input"],
Cell[5045, 155, 95279, 1715, 535, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100361, 1875, 5388, 132, 420, "Input"],
Cell[105752, 2009, 5060, 98, 596, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
