(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18612,        543]
NotebookOptionsPosition[     16218,        455]
NotebookOutlinePosition[     16871,        480]
CellTagsIndexPosition[     16785,        475]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<SpinDynamica`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.450336910857295*^9, 3.450336917940371*^9}, {
  3.5689026689710364`*^9, 3.5689026699820943`*^9}}],

Cell[BoxData[
 TagBox[
  FrameBox["\<\"SpinDynamica version 3.0.1 loaded\"\>"],
  DisplayForm]], "Print",
 CellChangeTimes->{3.712160637594316*^9}],

Cell[BoxData[
 TemplateBox[{
  "ModifyBuiltIn","report",
   "\"The following built-in routines have been modified in SpinDynamica: \\!\
\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"Chop\\\", \\\",\\\", \\\"Dot\\\", \
\\\",\\\", \\\"Duration\\\", \\\",\\\", \\\"Exp\\\", \\\",\\\", \
\\\"Expand\\\", \\\",\\\", \\\"ExpandAll\\\", \\\",\\\", \\\"NumericQ\\\", \\\
\",\\\", \\\"Plus\\\", \\\",\\\", \\\"Power\\\", \\\",\\\", \\\"Simplify\\\", \
\\\",\\\", \\\"Times\\\", \\\",\\\", \\\"WignerD\\\"}], \\\"}\\\"}]\\). \
\\nEvaluate \
??\\!\\(\\*\\nStyleBox[\\\"symbol\\\",\\nFontSlant->\\\"Italic\\\"]\\) to \
generate the additional definitions for \
\\!\\(\\*\\nStyleBox[\\\"symbol\\\",\\nFontSlant->\\\"Italic\\\"]\\).\"",2,1,
   1,29119468922724438061,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.712160638673586*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["SingleTransitionOperator", "Subsubtitle",
 CellChangeTimes->{{3.456163949016762*^9, 3.4561639600646276`*^9}, {
   3.502944767095223*^9, 3.5029447709877853`*^9}, {3.502947158432171*^9, 
   3.5029471614288597`*^9}, 3.502947452352915*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "SingleTransitionOperator"}]], "Input",
 CellChangeTimes->{{3.5029428509553127`*^9, 3.502942851564311*^9}, {
   3.502944772759568*^9, 3.502944773205044*^9}, 3.502947164641993*^9, 
   3.502947455880684*^9}],

Cell[BoxData[
 StyleBox["\<\"SingleTransitionOperator[{r,s}, \[Mu]] defines a single \
transition operator within the current basis. Allowed values of \[Mu] are \
\\\"x\\\", \\\"y\\\", \\\"z\\\", \\\"+\\\",\\\"-\\\" or \\\"u\\\", \\\"E\\\", \
\\\"1\\\" for the Unity Operator. The state identifiers {r,s} must be members \
of the BasisLabels for the current basis. The most general form is \
SingleTransitionOperator[{{r,s},basis}, \[Mu]] which constructs a single \
transition operator for kets within any basis. \\n\"\>", "MSG"]], "Print", \
"PrintUsage",
 CellChangeTimes->{3.7121606390774145`*^9},
 CellTags->"Info23712164238-5320435"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2 spins-1/2", "Subsection",
 CellChangeTimes->{{3.50294288940539*^9, 3.502942891122905*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSpinSystem", "[", "2", "]"}]], "Input",
 CellChangeTimes->{{3.45616396286911*^9, 3.45616396576895*^9}, 
   3.456201606022471*^9, 3.456204541615698*^9, 3.456204576928049*^9}],

Cell[BoxData[
 TemplateBox[{
  "SetSpinSystem","set",
   "\"the spin system has been set to \\!\\(\\*RowBox[{\\\"{\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}]\\)\"",2,3,2,29119468922724438061,"Local"},
  
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.456163966369556*^9, {3.456164286553218*^9, 3.45616430554272*^9}, 
   3.456164374062786*^9, 3.456164593915292*^9, 3.4562015544899282`*^9, 
   3.456201608205554*^9, 3.4562021802379427`*^9, 3.456202498330545*^9, 
   3.4562028142931004`*^9, 3.456203069214973*^9, 3.456204078992474*^9, 
   3.456204140752467*^9, 3.456204494804265*^9, 3.4562045420959673`*^9, {
   3.456204577367599*^9, 3.456204583615263*^9}, 3.456204854481304*^9, 
   3.45620489799152*^9, 3.461036948022011*^9, 3.461066145853022*^9, 
   3.502942771367139*^9, {3.502943046043352*^9, 3.5029430543488607`*^9}, 
   3.502944776994608*^9, 3.5029449033425407`*^9, 3.5029471727514277`*^9, 
   3.502947462183405*^9, 3.515083938892797*^9, 3.568902674171334*^9, 
   3.7121606391044474`*^9}],

Cell[BoxData[
 TemplateBox[{
  "SetBasis","set",
   "\"the state basis has been set to \\!\\(\\*RowBox[{\\\"ZeemanBasis\\\", \
\\\"[\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", \
RowBox[{\\\"1\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", \
FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"BasisLabels\\\", \\\"\[Rule]\\\", \\\"Automatic\\\"}]}], \
\\\"]\\\"}]\\).\"",2,3,3,29119468922724438061,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.456163966369556*^9, {3.456164286553218*^9, 3.45616430554272*^9}, 
   3.456164374062786*^9, 3.456164593915292*^9, 3.4562015544899282`*^9, 
   3.456201608205554*^9, 3.4562021802379427`*^9, 3.456202498330545*^9, 
   3.4562028142931004`*^9, 3.456203069214973*^9, 3.456204078992474*^9, 
   3.456204140752467*^9, 3.456204494804265*^9, 3.4562045420959673`*^9, {
   3.456204577367599*^9, 3.456204583615263*^9}, 3.456204854481304*^9, 
   3.45620489799152*^9, 3.461036948022011*^9, 3.461066145853022*^9, 
   3.502942771367139*^9, {3.502943046043352*^9, 3.5029430543488607`*^9}, 
   3.502944776994608*^9, 3.5029449033425407`*^9, 3.5029471727514277`*^9, 
   3.502947462183405*^9, 3.515083938892797*^9, 3.568902674171334*^9, 
   3.712160639142461*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BasisLabels", "[", "]"}]], "Input",
 CellChangeTimes->{{3.502947464726796*^9, 3.502947467197196*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.502947467706962*^9, 3.515083938925473*^9, 
  3.5689026744603505`*^9, 3.7121606391750045`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Ket", "[", "1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Ket", "[", "2", "]"}]}], "Input",
 CellChangeTimes->{{3.502947469547948*^9, 3.502947474893173*^9}}],

Cell[BoxData["\<\"\[LeftBracketingBar]\[Alpha]\[Alpha]\[RightAngleBracket]\"\>\
"], "Output",
 CellChangeTimes->{{3.502947471154978*^9, 3.502947475357711*^9}, 
   3.515083938963262*^9, 3.568902674500353*^9, 3.7121606391918545`*^9}],

Cell[BoxData["\<\"\[LeftBracketingBar]\[Beta]\[Alpha]\[RightAngleBracket]\"\>\
"], "Output",
 CellChangeTimes->{{3.502947471154978*^9, 3.502947475357711*^9}, 
   3.515083938963262*^9, 3.568902674500353*^9, 3.712160639193841*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingleTransitionOperator", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "\"\<x\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.502947476762969*^9, 3.502947483742403*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\<\"\[LeftBracketingBar]\[Beta]\[Alpha]\[RightAngleBracket]\"\>", 
    ".", "\<\"<\[Alpha]\[Alpha]|\"\>"}], "2"], "+", 
  FractionBox[
   RowBox[{"\<\"\[LeftBracketingBar]\[Alpha]\[Alpha]\[RightAngleBracket]\"\>",
     ".", "\<\"<\[Beta]\[Alpha]|\"\>"}], "2"]}]], "Output",
 CellChangeTimes->{3.5029474843976097`*^9, 3.515083938991094*^9, 
  3.568902674548355*^9, 3.71216063920585*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRepresentation", "[", "\[IndentingNewLine]", 
   RowBox[{"SingleTransitionOperator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "\"\<x\>\""}], "]"}], 
   "\[IndentingNewLine]", "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.50294749325079*^9, 3.502947506988913*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", 
      FractionBox["1", "2"], "0", "0"},
     {
      FractionBox["1", "2"], "0", "0", "0"},
     {"0", "0", "0", "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 1, 2, 2, 2}, {{2}, {1}}}, {
      Rational[1, 2], Rational[1, 2]}}]]]]], "Output",
 CellChangeTimes->{3.5029475075855837`*^9, 3.51508393902876*^9, 
  3.5689026746063585`*^9, 3.7121606392403765`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRepresentation", "[", "\[IndentingNewLine]", 
   RowBox[{"SingleTransitionOperator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", "\"\<y\>\""}], "]"}], 
   "\[IndentingNewLine]", "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.50294749325079*^9, 3.502947515237958*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      RowBox[{"-", 
       FractionBox["\[ImaginaryI]", "2"]}], "0"},
     {"0", "0", "0", "0"},
     {
      FractionBox["\[ImaginaryI]", "2"], "0", "0", "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 1, 1, 2, 2}, {{3}, {1}}}, {
      Complex[0, Rational[-1, 2]], Complex[0, Rational[1, 2]]}}]]]]], "Output",\

 CellChangeTimes->{{3.5029475075855837`*^9, 3.502947515972731*^9}, 
   3.515083939079896*^9, 3.568902674650361*^9, 3.7121606392733974`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ket", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"SingletTripletBasis", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.502947521731039*^9, 3.502947548365202*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
   "-", "\<\"\[LeftBracketingBar]\[Beta]\[Alpha]\[RightAngleBracket]\"\>"}], 
   "+", "\<\"\[LeftBracketingBar]\[Alpha]\[Beta]\[RightAngleBracket]\"\>"}], 
  SqrtBox["2"]]], "Output",
 CellChangeTimes->{{3.502947527542121*^9, 3.502947548869075*^9}, 
   3.515083939127681*^9, 3.5689026746893635`*^9, 3.712160639287408*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ket", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", 
    RowBox[{"SingletTripletBasis", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.502947521731039*^9, 3.502947557175233*^9}}],

Cell[BoxData["\<\"\[LeftBracketingBar]\[Alpha]\[Alpha]\[RightAngleBracket]\"\>\
"], "Output",
 CellChangeTimes->{{3.502947527542121*^9, 3.502947557639737*^9}, 
   3.515083939177285*^9, 3.5689026747253656`*^9, 3.712160639300417*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingleTransitionOperator", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", 
     RowBox[{"SingletTripletBasis", "[", "]"}]}], "}"}], ",", "\"\<z\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5029475636691637`*^9, 3.5029476171270723`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\<\"\[LeftBracketingBar]\[Beta]\[Alpha]\[RightAngleBracket]\"\>",
      ".", "\<\"<\[Alpha]\[Beta]|\"\>"}], "2"]}], "-", 
  FractionBox[
   RowBox[{"\<\"\[LeftBracketingBar]\[Alpha]\[Beta]\[RightAngleBracket]\"\>", 
    ".", "\<\"<\[Beta]\[Alpha]|\"\>"}], "2"]}]], "Output",
 CellChangeTimes->{{3.502947574969511*^9, 3.502947617644796*^9}, 
   3.51508393922514*^9, 3.568902674768368*^9, 3.7121606393259344`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRepresentation", "[", "\[IndentingNewLine]", 
   RowBox[{"SingleTransitionOperator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"SingletTripletBasis", "[", "]"}]}], "}"}], ",", "\"\<z\>\""}],
     "]"}], "\[IndentingNewLine]", "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.502947608503995*^9, 3.50294762315126*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0"},
     {"0", "0", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], "0"},
     {"0", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], "0", "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 0, 1, 2, 2}, {{3}, {2}}}, {
      Rational[-1, 2], Rational[-1, 2]}}]]]]], "Output",
 CellChangeTimes->{{3.502947609291416*^9, 3.5029476237214212`*^9}, 
   3.515083939276507*^9, 3.5689026748243713`*^9, 3.712160639357958*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetBasis", "[", 
  RowBox[{"SingletTripletBasis", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.502947627437855*^9, 3.5029476337802687`*^9}}],

Cell[BoxData[
 TemplateBox[{
  "SetBasis","set",
   "\"the state basis has been set to \
\\!\\(\\*RowBox[{\\\"SingletTripletBasis\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{\\\"{\\\", RowBox[{\\\"1\\\", \
\\\",\\\", FractionBox[\\\"1\\\", \\\"2\\\"]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"2\\\", \\\",\\\", FractionBox[\\\"1\\\", \\\"2\
\\\"]}], \\\"}\\\"}]}], \\\"}\\\"}], \\\",\\\", RowBox[{\\\"BasisLabels\\\", \
\\\"\[Rule]\\\", \\\"Automatic\\\"}]}], \\\"]\\\"}]\\).\"",2,14,4,
   29119468922724438061,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.5029476342529573`*^9, 3.51508393932873*^9, 
  3.5689026750453835`*^9, 3.7121606393714685`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixRepresentation", "[", "\[IndentingNewLine]", 
   RowBox[{"SingleTransitionOperator", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}], ",", 
       RowBox[{"SingletTripletBasis", "[", "]"}]}], "}"}], ",", "\"\<z\>\""}],
     "]"}], "\[IndentingNewLine]", "]"}], "//", "MatrixForm"}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["1", "2"], "0", "0", "0"},
     {"0", "0", "0", "0"},
     {"0", "0", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 1, 1, 2, 2}, {{1}, {3}}}, {
      Rational[1, 2], Rational[-1, 2]}}]]]]], "Output",
 CellChangeTimes->{3.502947641351223*^9, 3.5150839393771133`*^9, 
  3.5689026750953865`*^9, 3.7121606395124435`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1350, 633},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"mhl-default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info23712164238-5320435"->{
  Cell[2292, 66, 639, 10, 77, "Print",
   CellTags->"Info23712164238-5320435"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info23712164238-5320435", 16681, 469}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 197, 3, 30, "Input"],
Cell[767, 27, 147, 4, 36, "Print"],
Cell[917, 33, 836, 15, 40, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1790, 53, 241, 3, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2056, 60, 233, 4, 30, "Input"],
Cell[2292, 66, 639, 10, 77, "Print",
 CellTags->"Info23712164238-5320435"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2968, 81, 98, 1, 43, "Subsection"],
Cell[CellGroupData[{
Cell[3091, 86, 200, 3, 30, "Input"],
Cell[3294, 91, 1210, 21, 47, "Message"],
Cell[4507, 114, 1346, 22, 47, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5890, 141, 125, 2, 30, "Input"],
Cell[6018, 145, 208, 4, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6263, 154, 181, 3, 50, "Input"],
Cell[6447, 159, 231, 3, 30, "Output"],
Cell[6681, 164, 228, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6946, 172, 223, 5, 30, "Input"],
Cell[7172, 179, 436, 9, 54, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7645, 193, 359, 8, 69, "Input"],
Cell[8007, 203, 940, 27, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8984, 235, 359, 8, 69, "Input"],
Cell[9346, 245, 1038, 29, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10421, 279, 212, 5, 30, "Input"],
Cell[10636, 286, 372, 8, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11045, 299, 212, 5, 30, "Input"],
Cell[11260, 306, 231, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11528, 314, 327, 9, 30, "Input"],
Cell[11858, 325, 480, 10, 54, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12375, 340, 463, 11, 69, "Input"],
Cell[12841, 353, 1012, 29, 118, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13890, 387, 170, 3, 30, "Input"],
Cell[14063, 392, 712, 13, 47, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14812, 410, 398, 10, 69, "Input"],
Cell[15213, 422, 965, 28, 118, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

