(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    164491,       3175]
NotebookOptionsPosition[    161235,       3057]
NotebookOutlinePosition[    161815,       3081]
CellTagsIndexPosition[    161728,       3076]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MatrixPlot3D`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.5286452962232*^9, 3.528645320958768*^9}, {
  3.528645980477109*^9, 3.528645986295475*^9}, {3.52864608369553*^9, 
  3.528646086129029*^9}}],

Cell[BoxData["\<\"MatrixPlot3D` version 1\"\>"], "Print",
 CellChangeTimes->{
  3.528648197244664*^9, {3.5286483006533585`*^9, 3.528648327762339*^9}, 
   3.52864864578964*^9, 3.5286592778878465`*^9, 3.5286992351726046`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixPlot3D examples", "Title",
 CellChangeTimes->{{3.513500847669843*^9, 3.5135008536584544`*^9}, {
   3.5135009325218544`*^9, 3.513500935145627*^9}, {3.513501595294875*^9, 
   3.513501596116056*^9}, 3.513505600694357*^9, {3.5285568467626705`*^9, 
   3.5285568484150467`*^9}, {3.528641757985464*^9, 3.5286417633431683`*^9}}],

Cell["Instructions", "Subsubtitle",
 CellChangeTimes->{{3.528643351356619*^9, 3.528643355332336*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "MatrixPlot3D"}]], "Input",
 CellChangeTimes->{{3.5135065269462414`*^9, 3.513506529990619*^9}, 
   3.5285485845622096`*^9, 3.5285486790280447`*^9, {3.528643360009061*^9, 
   3.528643376092187*^9}}],

Cell[BoxData[
 StyleBox["\<\"MatrixPlot3D[matrix, displayoptions] provides 3D visualization \
of real matrices. \\n\\nExample: \
MatrixPlot3D[{{0,1,0},{1,0,0},{0,0,1}}]\\n\\nCompare with MatrixPlot\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellChangeTimes->{3.528699237515974*^9},
 CellTags->"Info3528702837-3198673"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic usage examples", "Subsubtitle",
 CellChangeTimes->{{3.528643336575365*^9, 3.5286433453880367`*^9}}],

Cell[CellGroupData[{

Cell["Error message: \"input is not MatrixQ\"", "Section",
 CellChangeTimes->{{3.513508762951459*^9, 3.5135087736368237`*^9}, 
   3.5135682194000096`*^9, {3.5286417786051135`*^9, 3.5286417804577775`*^9}, {
   3.5286420202726145`*^9, 3.528642027352795*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", "x", "]"}]], "Input",
 CellChangeTimes->{{3.5286418384010963`*^9, 3.5286418416657906`*^9}}],

Cell[BoxData["False"], "Output",
 CellChangeTimes->{
  3.52864184200628*^9, 3.528644977194459*^9, 3.528645087563162*^9, 
   3.5286453284094815`*^9, 3.5286458481368127`*^9, 3.528646037318843*^9, 
   3.5286482006996317`*^9, {3.528648305249968*^9, 3.5286483314776816`*^9}, 
   3.52864864863373*^9, 3.5286592837963424`*^9, 3.5286992407706547`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot3D", "[", "x", "]"}]], "Input",
 CellChangeTimes->{{3.513506133640696*^9, 3.5135061527782145`*^9}, {
  3.5135064571759167`*^9, 3.513506495480997*^9}, {3.5285486926576433`*^9, 
  3.5285487130669904`*^9}, {3.5285518903156495`*^9, 3.5285518921082273`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixPlot3D", "::", "\<\"inappropriateinput\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Input must be \
MatrixQ\\\\\\\"\\\", \\\"MT\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.5285518923986444`*^9, {3.528551951794051*^9, 3.528551993453955*^9}, 
   3.5286238251594543`*^9, 3.5286417753704624`*^9, {3.52864183165139*^9, 
   3.5286418429476337`*^9}, 3.528644977865424*^9, 3.5286450884043713`*^9, 
   3.528645329150547*^9, 3.52864584876772*^9, 3.5286460373488865`*^9, 
   3.528648201300496*^9, {3.528648305940962*^9, 3.528648332138632*^9}, 
   3.5286486487038307`*^9, 3.5286592844973507`*^9, 3.528690405919965*^9, 
   3.5286992408808126`*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{{3.5135061343216753`*^9, 3.513506250799162*^9}, {
   3.513506435464698*^9, 3.5135064644964433`*^9}, 3.513506497443819*^9, 
   3.5135089494496307`*^9, 3.513514856092966*^9, 3.51351626695688*^9, 
   3.5135201117719107`*^9, 3.5135678173018208`*^9, 3.5135678846486607`*^9, 
   3.5135695123792224`*^9, 3.5135699124645166`*^9, 3.51357010518163*^9, 
   3.5135709696546817`*^9, 3.513576659711485*^9, 3.5135784935884705`*^9, 
   3.5135787798400803`*^9, 3.5135803621953955`*^9, 3.5135814217089005`*^9, {
   3.5285486894830785`*^9, 3.5285487135576963`*^9}, 3.5285505669527473`*^9, 
   3.528550721374795*^9, 3.5285517946480865`*^9, {3.5285518881725683`*^9, 
   3.5285518923986444`*^9}, {3.52855195181408*^9, 3.528551993473984*^9}, 
   3.5286238251794834`*^9, 3.5286417753704624`*^9, {3.528641831671419*^9, 
   3.5286418429576483`*^9}, 3.5286449778754387`*^9, 3.5286450884043713`*^9, 
   3.528645329150547*^9, 3.528645848787749*^9, 3.528646037368915*^9, 
   3.528648201300496*^9, {3.528648305950976*^9, 3.5286483321486464`*^9}, 
   3.528648648713845*^9, 3.5286592845073647`*^9, 3.5286904059299793`*^9, 
   3.528699240890827*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input is MatrixQ", "Section",
 CellChangeTimes->{{3.513568228122552*^9, 3.513568237165555*^9}, {
  3.5286418538833585`*^9, 3.528641856346901*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "0.5"}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.5135059063939314`*^9, 3.513505918581456*^9}, {
   3.513505954533152*^9, 3.5135059778266463`*^9}, {3.528548755107442*^9, 
   3.52854875813179*^9}, {3.528623832229621*^9, 3.5286238648965936`*^9}, 
   3.5286239171517324`*^9, {3.528641864408493*^9, 3.52864186528976*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.9, 0.09999999999999998, 0}], 
      CuboidBox[{0.09999999999999998, 0.9, 0}, {0.9, 0.9, 0}], 
      CuboidBox[{0.9, 0.09999999999999998, 0}, {0.9, 0.9, 0}], 
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.09999999999999998, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{0.09999999999999998, 1.1, 0}, {0.9, 1.1, 2}], 
      CuboidBox[{0.09999999999999998, 1.9, 0}, {0.9, 1.9, 2}], 
      CuboidBox[{0.9, 1.1, 0}, {0.9, 1.9, 2}], 
      CuboidBox[{0.09999999999999998, 1.1, 0}, {0.09999999999999998, 1.9, 2}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 2.1, 0}, {0.9, 2.1, 0}], 
      CuboidBox[{0.09999999999999998, 2.9, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.9, 2.1, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.09999999999999998, 2.1, 0}, {0.09999999999999998, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.9, 
       0.09999999999999998, -0.5}], 
      CuboidBox[{1.1, 0.9, 0}, {1.9, 0.9, -0.5}], 
      CuboidBox[{1.9, 0.09999999999999998, 0}, {1.9, 0.9, -0.5}], 
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.1, 0.9, -0.5}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 1.1, 0}, {1.9, 1.1, 0}], 
      CuboidBox[{1.1, 1.9, 0}, {1.9, 1.9, 0}], 
      CuboidBox[{1.9, 1.1, 0}, {1.9, 1.9, 0}], 
      CuboidBox[{1.1, 1.1, 0}, {1.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 2.1, 0}, {1.9, 2.1, 0}], 
      CuboidBox[{1.1, 2.9, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.9, 2.1, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.1, 2.1, 0}, {1.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.9, 0.09999999999999998, 0}],
       CuboidBox[{2.1, 0.9, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.9, 0.09999999999999998, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 1.1, 0}, {2.9, 1.1, 0}], 
      CuboidBox[{2.1, 1.9, 0}, {2.9, 1.9, 0}], 
      CuboidBox[{2.9, 1.1, 0}, {2.9, 1.9, 0}], 
      CuboidBox[{2.1, 1.1, 0}, {2.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{2.1, 2.1, 0}, {2.9, 2.1, 1}], 
      CuboidBox[{2.1, 2.9, 0}, {2.9, 2.9, 1}], 
      CuboidBox[{2.9, 2.1, 0}, {2.9, 2.9, 1}], 
      CuboidBox[{2.1, 2.1, 0}, {2.1, 2.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 0.09999999999999998, -0.001}, {
     0.9, 0.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 1.1, 1.999}, {0.9, 1.9, 2}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 2.1, -0.001}, {0.9, 2.9, 0}]}, 
   {EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], FaceForm[RGBColor[
    0.1, 0.1, 0.5]], 
    CuboidBox[{1.1, 0.09999999999999998, -0.501}, {1.9, 0.9, -0.5}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 1.1, -0.001}, {1.9, 1.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 2.1, -0.001}, {1.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 0.09999999999999998, -0.001}, {2.9, 0.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 1.1, -0.001}, {2.9, 1.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{2.1, 2.1, 0.999}, {2.9, 2.9, 1}]}, {}, {}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{360., 360.},
  SphericalRegion->True,
  ViewPoint->{2, -2, 2},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{
  3.513505919062147*^9, {3.5135059550238576`*^9, 3.5135059781771507`*^9}, 
   3.5135061466994734`*^9, {3.5135062026999984`*^9, 3.513506248455792*^9}, {
   3.5135064332114573`*^9, 3.513506449564973*^9}, 3.5135065337159758`*^9, 
   3.5135089449431505`*^9, 3.513514854831152*^9, 3.5135162662158146`*^9, 
   3.5135201112711906`*^9, 3.5135678165907984`*^9, 3.5135678840177536`*^9, 
   3.5135695125394526`*^9, 3.513570105341861*^9, {3.513570953621627*^9, 
   3.5135709697948833`*^9}, 3.5135766598717155`*^9, 3.513578494359579*^9, 
   3.513578779990296*^9, 3.513580362595971*^9, 3.5135814220393763`*^9, {
   3.5285487483377075`*^9, 3.5285487589329424`*^9}, 3.5285517966810093`*^9, {
   3.5285519753078623`*^9, 3.528551994475424*^9}, {3.5286238288447533`*^9, 
   3.5286238653472414`*^9}, {3.5286239149986367`*^9, 3.52862393856252*^9}, {
   3.528641861774706*^9, 3.5286418661309695`*^9}, 3.528643862611768*^9, 
   3.5286449800585775`*^9, 3.528645089856459*^9, 3.5286453307027793`*^9, 
   3.5286457719172144`*^9, 3.528645851351435*^9, {3.528645899200238*^9, 
   3.528645911387763*^9}, {3.528646025391693*^9, 3.5286460374991026`*^9}, 
   3.528648203443578*^9, {3.5286483072728767`*^9, 3.528648333490576*^9}, 
   3.5286486489441757`*^9, 3.5286592858593087`*^9, {3.5286904078727727`*^9, 
   3.528690419970168*^9}, 3.5286992410610723`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot3D", "[", 
  RowBox[{"IdentityMatrix", "[", "6", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5135059999584703`*^9, 3.513506011424958*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.9, 0.09999999999999998, 1}], 
      CuboidBox[{0.09999999999999998, 0.9, 0}, {0.9, 0.9, 1}], 
      CuboidBox[{0.9, 0.09999999999999998, 0}, {0.9, 0.9, 1}], 
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.09999999999999998, 0.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 1.1, 0}, {0.9, 1.1, 0}], 
      CuboidBox[{0.09999999999999998, 1.9, 0}, {0.9, 1.9, 0}], 
      CuboidBox[{0.9, 1.1, 0}, {0.9, 1.9, 0}], 
      CuboidBox[{0.09999999999999998, 1.1, 0}, {0.09999999999999998, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 2.1, 0}, {0.9, 2.1, 0}], 
      CuboidBox[{0.09999999999999998, 2.9, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.9, 2.1, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.09999999999999998, 2.1, 0}, {0.09999999999999998, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 3.1, 0}, {0.9, 3.1, 0}], 
      CuboidBox[{0.09999999999999998, 3.9, 0}, {0.9, 3.9, 0}], 
      CuboidBox[{0.9, 3.1, 0}, {0.9, 3.9, 0}], 
      CuboidBox[{0.09999999999999998, 3.1, 0}, {0.09999999999999998, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 4.1, 0}, {0.9, 4.1, 0}], 
      CuboidBox[{0.09999999999999998, 4.9, 0}, {0.9, 4.9, 0}], 
      CuboidBox[{0.9, 4.1, 0}, {0.9, 4.9, 0}], 
      CuboidBox[{0.09999999999999998, 4.1, 0}, {0.09999999999999998, 4.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 5.1, 0}, {0.9, 5.1, 0}], 
      CuboidBox[{0.09999999999999998, 5.9, 0}, {0.9, 5.9, 0}], 
      CuboidBox[{0.9, 5.1, 0}, {0.9, 5.9, 0}], 
      CuboidBox[{0.09999999999999998, 5.1, 0}, {0.09999999999999998, 5.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.9, 0.09999999999999998, 0}],
       CuboidBox[{1.1, 0.9, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.9, 0.09999999999999998, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{1.1, 1.1, 0}, {1.9, 1.1, 1}], 
      CuboidBox[{1.1, 1.9, 0}, {1.9, 1.9, 1}], 
      CuboidBox[{1.9, 1.1, 0}, {1.9, 1.9, 1}], 
      CuboidBox[{1.1, 1.1, 0}, {1.1, 1.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 2.1, 0}, {1.9, 2.1, 0}], 
      CuboidBox[{1.1, 2.9, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.9, 2.1, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.1, 2.1, 0}, {1.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 3.1, 0}, {1.9, 3.1, 0}], 
      CuboidBox[{1.1, 3.9, 0}, {1.9, 3.9, 0}], 
      CuboidBox[{1.9, 3.1, 0}, {1.9, 3.9, 0}], 
      CuboidBox[{1.1, 3.1, 0}, {1.1, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 4.1, 0}, {1.9, 4.1, 0}], 
      CuboidBox[{1.1, 4.9, 0}, {1.9, 4.9, 0}], 
      CuboidBox[{1.9, 4.1, 0}, {1.9, 4.9, 0}], 
      CuboidBox[{1.1, 4.1, 0}, {1.1, 4.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 5.1, 0}, {1.9, 5.1, 0}], 
      CuboidBox[{1.1, 5.9, 0}, {1.9, 5.9, 0}], 
      CuboidBox[{1.9, 5.1, 0}, {1.9, 5.9, 0}], 
      CuboidBox[{1.1, 5.1, 0}, {1.1, 5.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.9, 0.09999999999999998, 0}],
       CuboidBox[{2.1, 0.9, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.9, 0.09999999999999998, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 1.1, 0}, {2.9, 1.1, 0}], 
      CuboidBox[{2.1, 1.9, 0}, {2.9, 1.9, 0}], 
      CuboidBox[{2.9, 1.1, 0}, {2.9, 1.9, 0}], 
      CuboidBox[{2.1, 1.1, 0}, {2.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{2.1, 2.1, 0}, {2.9, 2.1, 1}], 
      CuboidBox[{2.1, 2.9, 0}, {2.9, 2.9, 1}], 
      CuboidBox[{2.9, 2.1, 0}, {2.9, 2.9, 1}], 
      CuboidBox[{2.1, 2.1, 0}, {2.1, 2.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 3.1, 0}, {2.9, 3.1, 0}], 
      CuboidBox[{2.1, 3.9, 0}, {2.9, 3.9, 0}], 
      CuboidBox[{2.9, 3.1, 0}, {2.9, 3.9, 0}], 
      CuboidBox[{2.1, 3.1, 0}, {2.1, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 4.1, 0}, {2.9, 4.1, 0}], 
      CuboidBox[{2.1, 4.9, 0}, {2.9, 4.9, 0}], 
      CuboidBox[{2.9, 4.1, 0}, {2.9, 4.9, 0}], 
      CuboidBox[{2.1, 4.1, 0}, {2.1, 4.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 5.1, 0}, {2.9, 5.1, 0}], 
      CuboidBox[{2.1, 5.9, 0}, {2.9, 5.9, 0}], 
      CuboidBox[{2.9, 5.1, 0}, {2.9, 5.9, 0}], 
      CuboidBox[{2.1, 5.1, 0}, {2.1, 5.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{3.1, 0.09999999999999998, 0}, {3.9, 0.09999999999999998, 0}],
       CuboidBox[{3.1, 0.9, 0}, {3.9, 0.9, 0}], 
      CuboidBox[{3.9, 0.09999999999999998, 0}, {3.9, 0.9, 0}], 
      CuboidBox[{3.1, 0.09999999999999998, 0}, {3.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{3.1, 1.1, 0}, {3.9, 1.1, 0}], 
      CuboidBox[{3.1, 1.9, 0}, {3.9, 1.9, 0}], 
      CuboidBox[{3.9, 1.1, 0}, {3.9, 1.9, 0}], 
      CuboidBox[{3.1, 1.1, 0}, {3.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{3.1, 2.1, 0}, {3.9, 2.1, 0}], 
      CuboidBox[{3.1, 2.9, 0}, {3.9, 2.9, 0}], 
      CuboidBox[{3.9, 2.1, 0}, {3.9, 2.9, 0}], 
      CuboidBox[{3.1, 2.1, 0}, {3.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{3.1, 3.1, 0}, {3.9, 3.1, 1}], 
      CuboidBox[{3.1, 3.9, 0}, {3.9, 3.9, 1}], 
      CuboidBox[{3.9, 3.1, 0}, {3.9, 3.9, 1}], 
      CuboidBox[{3.1, 3.1, 0}, {3.1, 3.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{3.1, 4.1, 0}, {3.9, 4.1, 0}], 
      CuboidBox[{3.1, 4.9, 0}, {3.9, 4.9, 0}], 
      CuboidBox[{3.9, 4.1, 0}, {3.9, 4.9, 0}], 
      CuboidBox[{3.1, 4.1, 0}, {3.1, 4.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{3.1, 5.1, 0}, {3.9, 5.1, 0}], 
      CuboidBox[{3.1, 5.9, 0}, {3.9, 5.9, 0}], 
      CuboidBox[{3.9, 5.1, 0}, {3.9, 5.9, 0}], 
      CuboidBox[{3.1, 5.1, 0}, {3.1, 5.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{4.1, 0.09999999999999998, 0}, {4.9, 0.09999999999999998, 0}],
       CuboidBox[{4.1, 0.9, 0}, {4.9, 0.9, 0}], 
      CuboidBox[{4.9, 0.09999999999999998, 0}, {4.9, 0.9, 0}], 
      CuboidBox[{4.1, 0.09999999999999998, 0}, {4.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{4.1, 1.1, 0}, {4.9, 1.1, 0}], 
      CuboidBox[{4.1, 1.9, 0}, {4.9, 1.9, 0}], 
      CuboidBox[{4.9, 1.1, 0}, {4.9, 1.9, 0}], 
      CuboidBox[{4.1, 1.1, 0}, {4.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{4.1, 2.1, 0}, {4.9, 2.1, 0}], 
      CuboidBox[{4.1, 2.9, 0}, {4.9, 2.9, 0}], 
      CuboidBox[{4.9, 2.1, 0}, {4.9, 2.9, 0}], 
      CuboidBox[{4.1, 2.1, 0}, {4.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{4.1, 3.1, 0}, {4.9, 3.1, 0}], 
      CuboidBox[{4.1, 3.9, 0}, {4.9, 3.9, 0}], 
      CuboidBox[{4.9, 3.1, 0}, {4.9, 3.9, 0}], 
      CuboidBox[{4.1, 3.1, 0}, {4.1, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{4.1, 4.1, 0}, {4.9, 4.1, 1}], 
      CuboidBox[{4.1, 4.9, 0}, {4.9, 4.9, 1}], 
      CuboidBox[{4.9, 4.1, 0}, {4.9, 4.9, 1}], 
      CuboidBox[{4.1, 4.1, 0}, {4.1, 4.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{4.1, 5.1, 0}, {4.9, 5.1, 0}], 
      CuboidBox[{4.1, 5.9, 0}, {4.9, 5.9, 0}], 
      CuboidBox[{4.9, 5.1, 0}, {4.9, 5.9, 0}], 
      CuboidBox[{4.1, 5.1, 0}, {4.1, 5.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{5.1, 0.09999999999999998, 0}, {5.9, 0.09999999999999998, 0}],
       CuboidBox[{5.1, 0.9, 0}, {5.9, 0.9, 0}], 
      CuboidBox[{5.9, 0.09999999999999998, 0}, {5.9, 0.9, 0}], 
      CuboidBox[{5.1, 0.09999999999999998, 0}, {5.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{5.1, 1.1, 0}, {5.9, 1.1, 0}], 
      CuboidBox[{5.1, 1.9, 0}, {5.9, 1.9, 0}], 
      CuboidBox[{5.9, 1.1, 0}, {5.9, 1.9, 0}], 
      CuboidBox[{5.1, 1.1, 0}, {5.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{5.1, 2.1, 0}, {5.9, 2.1, 0}], 
      CuboidBox[{5.1, 2.9, 0}, {5.9, 2.9, 0}], 
      CuboidBox[{5.9, 2.1, 0}, {5.9, 2.9, 0}], 
      CuboidBox[{5.1, 2.1, 0}, {5.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{5.1, 3.1, 0}, {5.9, 3.1, 0}], 
      CuboidBox[{5.1, 3.9, 0}, {5.9, 3.9, 0}], 
      CuboidBox[{5.9, 3.1, 0}, {5.9, 3.9, 0}], 
      CuboidBox[{5.1, 3.1, 0}, {5.1, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{5.1, 4.1, 0}, {5.9, 4.1, 0}], 
      CuboidBox[{5.1, 4.9, 0}, {5.9, 4.9, 0}], 
      CuboidBox[{5.9, 4.1, 0}, {5.9, 4.9, 0}], 
      CuboidBox[{5.1, 4.1, 0}, {5.1, 4.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{5.1, 5.1, 0}, {5.9, 5.1, 1}], 
      CuboidBox[{5.1, 5.9, 0}, {5.9, 5.9, 1}], 
      CuboidBox[{5.9, 5.1, 0}, {5.9, 5.9, 1}], 
      CuboidBox[{5.1, 5.1, 0}, {5.1, 5.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 0.09999999999999998, 0.999}, {
     0.9, 0.9, 1}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 1.1, -0.001}, {0.9, 1.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 2.1, -0.001}, {0.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 3.1, -0.001}, {0.9, 3.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 4.1, -0.001}, {0.9, 4.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 5.1, -0.001}, {0.9, 5.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 0.09999999999999998, -0.001}, {1.9, 0.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{1.1, 1.1, 0.999}, {1.9, 1.9, 1}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 2.1, -0.001}, {1.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 3.1, -0.001}, {1.9, 3.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 4.1, -0.001}, {1.9, 4.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 5.1, -0.001}, {1.9, 5.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 0.09999999999999998, -0.001}, {2.9, 0.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 1.1, -0.001}, {2.9, 1.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{2.1, 2.1, 0.999}, {2.9, 2.9, 1}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 3.1, -0.001}, {2.9, 3.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 4.1, -0.001}, {2.9, 4.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 5.1, -0.001}, {2.9, 5.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 0.09999999999999998, -0.001}, {3.9, 0.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 1.1, -0.001}, {3.9, 1.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 2.1, -0.001}, {3.9, 2.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{3.1, 3.1, 0.999}, {3.9, 3.9, 1}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 4.1, -0.001}, {3.9, 4.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 5.1, -0.001}, {3.9, 5.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{4.1, 0.09999999999999998, -0.001}, {4.9, 0.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{4.1, 1.1, -0.001}, {4.9, 1.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{4.1, 2.1, -0.001}, {4.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{4.1, 3.1, -0.001}, {4.9, 3.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{4.1, 4.1, 0.999}, {4.9, 4.9, 1}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{4.1, 5.1, -0.001}, {4.9, 5.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{5.1, 0.09999999999999998, -0.001}, {5.9, 0.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{5.1, 1.1, -0.001}, {5.9, 1.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{5.1, 2.1, -0.001}, {5.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{5.1, 3.1, -0.001}, {5.9, 3.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{5.1, 4.1, -0.001}, {5.9, 4.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{5.1, 5.1, 0.999}, {5.9, 5.9, 1}]}, {}, {}},
  Boxed->False,
  SphericalRegion->True,
  ViewPoint->{2, -2, 2},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{{3.5135060060372114`*^9, 3.51350601206588*^9}, 
   3.5135061476508417`*^9, {3.5135062039718275`*^9, 3.513506249607448*^9}, {
   3.5135064344031715`*^9, 3.5135064504562545`*^9}, 3.5135089466255693`*^9, 
   3.5135148556923904`*^9, 3.5135162666664624`*^9, 3.513520111711824*^9, 
   3.513567817081504*^9, 3.5135678844984446`*^9, 3.513569513090245*^9, 
   3.5135701058325663`*^9, {3.5135709702956033`*^9, 3.5135709764144015`*^9}, 
   3.5135766604124928`*^9, 3.513578494990486*^9, 3.513578780521059*^9, 
   3.513580363246907*^9, 3.513581422590168*^9, 3.528548750610976*^9, 
   3.5286418699364414`*^9, 3.528644981290349*^9, 3.5286450911383023`*^9, 
   3.528645341267971*^9, 3.528646037989808*^9, 3.5286486495350256`*^9, 
   3.5286592873514547`*^9, 3.5286992418421955`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display options", "Section",
 CellChangeTimes->{{3.5286420417134447`*^9, 3.5286420553029857`*^9}, {
  3.5286423918669405`*^9, 3.5286423950214767`*^9}, {3.5286429562284527`*^9, 
  3.528642957249922*^9}, {3.52864341126276*^9, 3.5286434135460434`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "MatrixPlot3D", "]"}]], "Input",
 CellChangeTimes->{{3.5286428036891117`*^9, 3.5286428093372335`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RowLabels", "\[Rule]", "False"}], ",", 
   RowBox[{"ColumnLabels", "\[Rule]", "False"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.528642809667709*^9, {3.5286428534506655`*^9, 3.528642855723934*^9}, 
   3.5286428950104256`*^9, 3.52864498252212*^9, {3.5286450922198577`*^9, 
   3.528645093712003*^9}, 3.5286451412904177`*^9, 3.528645342399598*^9, 
   3.528646038079938*^9, 3.5286486497553425`*^9, 3.528659288793528*^9, 
   3.528699241982397*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColumnLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.528642057335909*^9, 3.528642101659643*^9}, {
  3.528642228552106*^9, 3.528642243543662*^9}, {3.528642281508253*^9, 
  3.528642283991824*^9}, {3.528642332912168*^9, 3.528642359450328*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.9, 0.09999999999999998, 2}], 
      CuboidBox[{0.09999999999999998, 0.9, 0}, {0.9, 0.9, 2}], 
      CuboidBox[{0.9, 0.09999999999999998, 0}, {0.9, 0.9, 2}], 
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.09999999999999998, 0.9, 2}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{0.09999999999999998, 1.1, 0}, {0.9, 1.1, 2}], 
      CuboidBox[{0.09999999999999998, 1.9, 0}, {0.9, 1.9, 2}], 
      CuboidBox[{0.9, 1.1, 0}, {0.9, 1.9, 2}], 
      CuboidBox[{0.09999999999999998, 1.1, 0}, {0.09999999999999998, 1.9, 2}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 2.1, 0}, {0.9, 2.1, 0}], 
      CuboidBox[{0.09999999999999998, 2.9, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.9, 2.1, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.09999999999999998, 2.1, 0}, {0.09999999999999998, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.9, 0.09999999999999998, 0}],
       CuboidBox[{1.1, 0.9, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.9, 0.09999999999999998, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{1.1, 1.1, 0}, {1.9, 1.1, 1}], 
      CuboidBox[{1.1, 1.9, 0}, {1.9, 1.9, 1}], 
      CuboidBox[{1.9, 1.1, 0}, {1.9, 1.9, 1}], 
      CuboidBox[{1.1, 1.1, 0}, {1.1, 1.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{1.1, 2.1, 0}, {1.9, 2.1, 1}], 
      CuboidBox[{1.1, 2.9, 0}, {1.9, 2.9, 1}], 
      CuboidBox[{1.9, 2.1, 0}, {1.9, 2.9, 1}], 
      CuboidBox[{1.1, 2.1, 0}, {1.1, 2.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 0.09999999999999998, 1.999}, {
     0.9, 0.9, 2}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 1.1, 1.999}, {0.9, 1.9, 2}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 2.1, -0.001}, {0.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 0.09999999999999998, -0.001}, {1.9, 0.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{1.1, 1.1, 0.999}, {1.9, 1.9, 1}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{1.1, 2.1, 0.999}, {1.9, 2.9, 1}]}, {Text3DBox[
     FormBox[
      StyleBox["\<\"a\"\>", "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {2.3, 0.5, 0}], Text3DBox[
     FormBox[
      StyleBox["\<\"b\"\>", "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {2.3, 1.5, 0}], Text3DBox[
     FormBox[
      StyleBox["\<\"c\"\>", "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {2.3, 2.5, 0}]}, {}},
  Boxed->False,
  SphericalRegion->True,
  ViewPoint->{2, -2, 2},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{3.528648665197547*^9, 3.5286592899551983`*^9, 
  3.528699242092555*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"RowLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<row 1\>\"", ",", "\"\<row 2\>\""}], "}"}]}], ",", 
   RowBox[{"ColumnLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<col 1\>\"", ",", "\"\<col 2\>\"", ",", "\"\<col 3\>\""}], 
     "}"}]}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], ",", 
   RowBox[{"ViewVertical", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5286424093020115`*^9, 3.528642432805808*^9}, {
  3.528642465022133*^9, 3.528642491740552*^9}, {3.5286425695123825`*^9, 
  3.5286425960104847`*^9}, {3.5286436688231134`*^9, 3.5286437335161376`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.9, 0.09999999999999998, 2}], 
      CuboidBox[{0.09999999999999998, 0.9, 0}, {0.9, 0.9, 2}], 
      CuboidBox[{0.9, 0.09999999999999998, 0}, {0.9, 0.9, 2}], 
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.09999999999999998, 0.9, 2}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{0.09999999999999998, 1.1, 0}, {0.9, 1.1, 1}], 
      CuboidBox[{0.09999999999999998, 1.9, 0}, {0.9, 1.9, 1}], 
      CuboidBox[{0.9, 1.1, 0}, {0.9, 1.9, 1}], 
      CuboidBox[{0.09999999999999998, 1.1, 0}, {0.09999999999999998, 1.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 2.1, 0}, {0.9, 2.1, 0}], 
      CuboidBox[{0.09999999999999998, 2.9, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.9, 2.1, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.09999999999999998, 2.1, 0}, {0.09999999999999998, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.9, 0.09999999999999998, 0}],
       CuboidBox[{1.1, 0.9, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.9, 0.09999999999999998, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{1.1, 1.1, 0}, {1.9, 1.1, -1}], 
      CuboidBox[{1.1, 1.9, 0}, {1.9, 1.9, -1}], 
      CuboidBox[{1.9, 1.1, 0}, {1.9, 1.9, -1}], 
      CuboidBox[{1.1, 1.1, 0}, {1.1, 1.9, -1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{1.1, 2.1, 0}, {1.9, 2.1, -2}], 
      CuboidBox[{1.1, 2.9, 0}, {1.9, 2.9, -2}], 
      CuboidBox[{1.9, 2.1, 0}, {1.9, 2.9, -2}], 
      CuboidBox[{1.1, 2.1, 0}, {1.1, 2.9, -2}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 0.09999999999999998, 1.999}, {
     0.9, 0.9, 2}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 1.1, 0.999}, {0.9, 1.9, 1}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 2.1, -0.001}, {0.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 0.09999999999999998, -0.001}, {1.9, 0.9, 0}]}, 
   {EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], FaceForm[RGBColor[
    0.1, 0.1, 0.5]], CuboidBox[{1.1, 1.1, -1.001}, {1.9, 1.9, -1}]}, 
   {EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], FaceForm[RGBColor[
    0.1, 0.1, 0.5]], CuboidBox[{1.1, 2.1, -2.001}, {1.9, 2.9, -2}]}, {
    Text3DBox[
     FormBox[
      StyleBox["\<\"col 1\"\>", "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {2.3, 0.5, 0}], Text3DBox[
     FormBox[
      StyleBox["\<\"col 2\"\>", "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {2.3, 1.5, 0}], Text3DBox[
     FormBox[
      StyleBox["\<\"col 3\"\>", "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {2.3, 2.5, 0}]}, {Text3DBox[
     FormBox[
      StyleBox["\<\"row 1\"\>", "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {0.5, 3.5999999999999996`, 0}], 
    Text3DBox[
     FormBox[
      StyleBox["\<\"row 2\"\>", "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {1.5, 3.5999999999999996`, 0}]}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{306., 306.},
  SphericalRegion->True,
  ViewPoint->{2, 2, 2},
  ViewVertical->{0, 0, 2}]], "Output",
 CellChangeTimes->{{3.528642578695587*^9, 3.528642596411061*^9}, 
   3.528642947916501*^9, {3.5286436710463104`*^9, 3.5286437341370306`*^9}, 
   3.5286449848955326`*^9, 3.5286451441545362`*^9, 3.528646038360341*^9, 
   3.528648650145904*^9, 3.528690167226741*^9, 3.528699242242771*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error message: labels have incompatible dimensions", "Section",
 CellChangeTimes->{{3.528643879145542*^9, 3.5286438979525857`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.5", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"RowLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<row 1\>\"", ",", "\"\<row 2\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5286439128439984`*^9, 3.5286440038248224`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.9, 0.09999999999999998, 2}], 
      CuboidBox[{0.09999999999999998, 0.9, 0}, {0.9, 0.9, 2}], 
      CuboidBox[{0.9, 0.09999999999999998, 0}, {0.9, 0.9, 2}], 
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.09999999999999998, 0.9, 2}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{0.09999999999999998, 1.1, 0}, {0.9, 1.1, 1}], 
      CuboidBox[{0.09999999999999998, 1.9, 0}, {0.9, 1.9, 1}], 
      CuboidBox[{0.9, 1.1, 0}, {0.9, 1.9, 1}], 
      CuboidBox[{0.09999999999999998, 1.1, 0}, {0.09999999999999998, 1.9, 1}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 2.1, 0}, {0.9, 2.1, 0}], 
      CuboidBox[{0.09999999999999998, 2.9, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.9, 2.1, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.09999999999999998, 2.1, 0}, {0.09999999999999998, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.9, 0.09999999999999998, 0}],
       CuboidBox[{1.1, 0.9, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.9, 0.09999999999999998, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{CuboidBox[{1.1, 1.1, 0}, {1.9, 1.1, 0.5}], 
      CuboidBox[{1.1, 1.9, 0}, {1.9, 1.9, 0.5}], 
      CuboidBox[{1.9, 1.1, 0}, {1.9, 1.9, 0.5}], 
      CuboidBox[{1.1, 1.1, 0}, {1.1, 1.9, 0.5}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 2.1, 0}, {1.9, 2.1, 0}], 
      CuboidBox[{1.1, 2.9, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.9, 2.1, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.1, 2.1, 0}, {1.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 0.09999999999999998, 1.999}, {
     0.9, 0.9, 2}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 1.1, 0.999}, {0.9, 1.9, 1}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 2.1, -0.001}, {0.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 0.09999999999999998, -0.001}, {1.9, 0.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{1.1, 1.1, 0.499}, {1.9, 1.9, 0.5}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 2.1, -0.001}, {1.9, 2.9, 0}]}, {}, {Text3DBox[
     FormBox[
      StyleBox["\<\"row 1\"\>", "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {0.5, 3.5999999999999996`, 0}], 
    Text3DBox[
     FormBox[
      StyleBox["\<\"row 2\"\>", "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {1.5, 3.5999999999999996`, 0}]}},
  Boxed->False,
  SphericalRegion->True,
  ViewPoint->{2, -2, 2},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{{3.5286439144763455`*^9, 3.528644004335557*^9}, 
   3.5286460385406*^9, 3.528648650306134*^9, 3.528690169510024*^9, 
   3.528699242372958*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.5", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"RowLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<row 1\>\"", ",", "\"\<row 2\>\"", ",", "\"\<row 3\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5286439128439984`*^9, 3.528644007760482*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixPlot3D", "::", "\<\"mismatcheddimensions\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Basis labels incompatible \
with the matrix dimensions\\\\\\\"\\\", \\\"MT\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.5286440084114175`*^9, 3.5286460385706434`*^9, 
  3.528648650336178*^9, 3.5286901707818527`*^9, 3.528699242403002*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.5286440084114175`*^9, 3.5286460385706434`*^9, 
  3.528648650416293*^9, 3.5286901707918673`*^9, 3.5286992424130163`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spin dynamics examples", "Subsubtitle",
 CellChangeTimes->{{3.528643312721064*^9, 3.528643322304845*^9}}],

Cell[CellGroupData[{

Cell["3D matrix representation of operators", "Section",
 CellChangeTimes->{{3.5135093540814624`*^9, 3.5135093556136656`*^9}, {
  3.528641893700613*^9, 3.528641912457584*^9}, {3.528643296057102*^9, 
  3.5286433103075933`*^9}, {3.5286434352772913`*^9, 3.528643436418933*^9}}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NMR`SpinOperators`\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.528641922552099*^9, 3.528641934168803*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSpinSystem", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "}"}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixPlot3D", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MatrixRepresentation", "[", 
    RowBox[{"opI", "[", "\"\<x\>\"", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ColumnLabels", "\[Rule]", 
    RowBox[{"BasisKets", "[", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ImageSize", "\[Rule]", "300"}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.5286430459274335`*^9, 3.5286431576080227`*^9}, {
  3.5286435637119713`*^9, 3.528643564152605*^9}, {3.528643764971368*^9, 
  3.528643809815851*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSpinSystem", "::", "\<\"set\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"the spin system has been set \
to \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\({\\({1, \
1}\\)}\\), \\\"MT\\\"]\\)\[NoBreak]\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.5286435645231376`*^9, {3.5286437654120016`*^9, 3.5286438101162834`*^9}, {
   3.528646038710845*^9, 3.5286460596409407`*^9}, 3.5286486505765233`*^9, 
   3.5286992664375615`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetBasis", "::", "\<\"set\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"the state basis has been set \
to \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(ZeemanBasis[\
\\(\\(\\(\\({\\({1, 1}\\)}\\)\\), \\(\\(BasisLabels \[Rule] \
Automatic\\)\\)\\)\\)]\\), \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\\"\\\\\
\\\".\\\\\\\"\\\", \\\"MT\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.5286435645231376`*^9, {3.5286437654120016`*^9, 3.5286438101162834`*^9}, {
   3.528646038710845*^9, 3.5286460596409407`*^9}, 3.5286486505765233`*^9, 
   3.528699266517677*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.9, 0.09999999999999998, 0}], 
      CuboidBox[{0.09999999999999998, 0.9, 0}, {0.9, 0.9, 0}], 
      CuboidBox[{0.9, 0.09999999999999998, 0}, {0.9, 0.9, 0}], 
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, {
       0.09999999999999998, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 1.1, 0}, 
       NCache[{0.9, 1.1, 2^Rational[-1, 2]}, {0.9, 1.1, 0.7071067811865475}]],
       CuboidBox[{0.09999999999999998, 1.9, 0}, 
       NCache[{0.9, 1.9, 2^Rational[-1, 2]}, {0.9, 1.9, 0.7071067811865475}]],
       CuboidBox[{0.9, 1.1, 0}, 
       NCache[{0.9, 1.9, 2^Rational[-1, 2]}, {0.9, 1.9, 0.7071067811865475}]],
       CuboidBox[{0.09999999999999998, 1.1, 0}, 
       NCache[{0.09999999999999998, 1.9, 2^Rational[-1, 2]}, {
        0.09999999999999998, 1.9, 0.7071067811865475}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 2.1, 0}, {0.9, 2.1, 0}], 
      CuboidBox[{0.09999999999999998, 2.9, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.9, 2.1, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.09999999999999998, 2.1, 0}, {0.09999999999999998, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{1.1, 0.09999999999999998, 0}, 
       NCache[{1.9, 0.09999999999999998, 2^Rational[-1, 2]}, {1.9, 
        0.09999999999999998, 0.7071067811865475}]], 
      CuboidBox[{1.1, 0.9, 0}, 
       NCache[{1.9, 0.9, 2^Rational[-1, 2]}, {1.9, 0.9, 0.7071067811865475}]],
       CuboidBox[{1.9, 0.09999999999999998, 0}, 
       NCache[{1.9, 0.9, 2^Rational[-1, 2]}, {1.9, 0.9, 0.7071067811865475}]],
       CuboidBox[{1.1, 0.09999999999999998, 0}, 
       NCache[{1.1, 0.9, 2^Rational[-1, 2]}, {1.1, 0.9, 0.7071067811865475}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 1.1, 0}, {1.9, 1.1, 0}], 
      CuboidBox[{1.1, 1.9, 0}, {1.9, 1.9, 0}], 
      CuboidBox[{1.9, 1.1, 0}, {1.9, 1.9, 0}], 
      CuboidBox[{1.1, 1.1, 0}, {1.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{1.1, 2.1, 0}, 
       NCache[{1.9, 2.1, 2^Rational[-1, 2]}, {1.9, 2.1, 0.7071067811865475}]],
       CuboidBox[{1.1, 2.9, 0}, 
       NCache[{1.9, 2.9, 2^Rational[-1, 2]}, {1.9, 2.9, 0.7071067811865475}]],
       CuboidBox[{1.9, 2.1, 0}, 
       NCache[{1.9, 2.9, 2^Rational[-1, 2]}, {1.9, 2.9, 0.7071067811865475}]],
       CuboidBox[{1.1, 2.1, 0}, 
       NCache[{1.1, 2.9, 2^Rational[-1, 2]}, {1.1, 2.9, 0.7071067811865475}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.9, 0.09999999999999998, 0}],
       CuboidBox[{2.1, 0.9, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.9, 0.09999999999999998, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{2.1, 1.1, 0}, 
       NCache[{2.9, 1.1, 2^Rational[-1, 2]}, {2.9, 1.1, 0.7071067811865475}]],
       CuboidBox[{2.1, 1.9, 0}, 
       NCache[{2.9, 1.9, 2^Rational[-1, 2]}, {2.9, 1.9, 0.7071067811865475}]],
       CuboidBox[{2.9, 1.1, 0}, 
       NCache[{2.9, 1.9, 2^Rational[-1, 2]}, {2.9, 1.9, 0.7071067811865475}]],
       CuboidBox[{2.1, 1.1, 0}, 
       NCache[{2.1, 1.9, 2^Rational[-1, 2]}, {2.1, 1.9, 0.7071067811865475}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 2.1, 0}, {2.9, 2.1, 0}], 
      CuboidBox[{2.1, 2.9, 0}, {2.9, 2.9, 0}], 
      CuboidBox[{2.9, 2.1, 0}, {2.9, 2.9, 0}], 
      CuboidBox[{2.1, 2.1, 0}, {2.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 0.09999999999999998, -0.001}, {
     0.9, 0.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 1.1, 0.7061067811865475}, 
     NCache[{0.9, 1.9, 2^Rational[-1, 2]}, {0.9, 1.9, 0.7071067811865475}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 2.1, -0.001}, {0.9, 2.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{1.1, 0.09999999999999998, 0.7061067811865475}, 
     NCache[{1.9, 0.9, 2^Rational[-1, 2]}, {1.9, 0.9, 0.7071067811865475}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 1.1, -0.001}, {1.9, 1.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{1.1, 2.1, 0.7061067811865475}, 
     NCache[{1.9, 2.9, 2^Rational[-1, 2]}, {1.9, 2.9, 0.7071067811865475}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 0.09999999999999998, -0.001}, {2.9, 0.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{2.1, 1.1, 0.7061067811865475}, 
     NCache[{2.9, 1.9, 2^Rational[-1, 2]}, {2.9, 1.9, 0.7071067811865475}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 2.1, -0.001}, {2.9, 2.9, 0}]}, {Text3DBox[
     FormBox[
      StyleBox[
       FormBox[
        TagBox[
         RowBox[{"\[LeftBracketingBar]", 
          TagBox["1",
           DisplayForm], 
          TagBox[
           RowBox[{"+", "1"}],
           DisplayForm], "\[RightAngleBracket]"}],
         DisplayForm],
        TraditionalForm], "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {3.4499999999999997`, 0.5, 0}], 
    Text3DBox[
     FormBox[
      StyleBox[
       FormBox[
        TagBox[
         RowBox[{"\[LeftBracketingBar]", 
          TagBox["1",
           DisplayForm], 
          TagBox["0",
           DisplayForm], "\[RightAngleBracket]"}],
         DisplayForm],
        TraditionalForm], "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {3.4499999999999997`, 1.5, 0}], 
    Text3DBox[
     FormBox[
      StyleBox[
       FormBox[
        TagBox[
         RowBox[{"\[LeftBracketingBar]", 
          TagBox["1",
           DisplayForm], 
          TagBox[
           RowBox[{"-", "1"}],
           DisplayForm], "\[RightAngleBracket]"}],
         DisplayForm],
        TraditionalForm], "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {3.4499999999999997`, 2.5, 0}]}, {}},
  Boxed->False,
  ImageSize->300,
  SphericalRegion->True,
  ViewPoint->{2, -2, 2},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{
  3.528643043864467*^9, {3.528643074388358*^9, 3.528643157998584*^9}, 
   3.528643564663339*^9, {3.5286437655722322`*^9, 3.5286438102464705`*^9}, {
   3.5286460387008305`*^9, 3.528646059811186*^9}, 3.528648650566509*^9, 
   3.528699266727979*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSpinSystem", "[", "2", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixPlot3D", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MatrixRepresentation", "[", 
    RowBox[{"opI", "[", 
     RowBox[{"1", ",", "\"\<z\>\""}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"RowLabels", "\[Rule]", 
    RowBox[{"BasisBras", "[", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"ColumnLabels", "\[Rule]", 
    RowBox[{"BasisKets", "[", "]"}]}]}], "\[IndentingNewLine]", 
  "]"}]}], "Input",
 CellChangeTimes->{
  3.5135681210285587`*^9, {3.5286434612947025`*^9, 3.528643550412848*^9}, {
   3.528643814112029*^9, 3.528643839648749*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSpinSystem", "::", "\<\"set\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"the spin system has been set \
to \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\({\\(\\({1, 1\
\\/2}\\)\\), \\(\\({2, 1\\/2}\\)\\)}\\), \\\"MT\\\"]\\)\[NoBreak]\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{{3.5286435437232285`*^9, 3.528643566455917*^9}, {
   3.5286438144525185`*^9, 3.5286438398890944`*^9}, {3.528646038750902*^9, 
   3.5286460609528275`*^9}, 3.5286486506265955`*^9, 3.5286992679096785`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetBasis", "::", "\<\"set\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"the state basis has been set \
to \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\(ZeemanBasis[\
\\(\\(\\(\\({\\(\\({1, 1\\/2}\\)\\), \\(\\({2, 1\\/2}\\)\\)}\\)\\), \
\\(\\(BasisLabels \[Rule] Automatic\\)\\)\\)\\)]\\), \\\"MT\\\"]\\)\[NoBreak]\
\\!\\(\\*StyleBox[\\\"\\\\\\\".\\\\\\\"\\\", \\\"MT\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellChangeTimes->{{3.5286435437232285`*^9, 3.528643566455917*^9}, {
   3.5286438144525185`*^9, 3.5286438398890944`*^9}, {3.528646038750902*^9, 
   3.5286460609528275`*^9}, 3.5286486506265955`*^9, 3.528699268029851*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, 
       NCache[{0.9, 0.09999999999999998, Rational[1, 2]}, {0.9, 
        0.09999999999999998, 0.5}]], 
      CuboidBox[{0.09999999999999998, 0.9, 0}, 
       NCache[{0.9, 0.9, Rational[1, 2]}, {0.9, 0.9, 0.5}]], 
      CuboidBox[{0.9, 0.09999999999999998, 0}, 
       NCache[{0.9, 0.9, Rational[1, 2]}, {0.9, 0.9, 0.5}]], 
      CuboidBox[{0.09999999999999998, 0.09999999999999998, 0}, 
       NCache[{0.09999999999999998, 0.9, Rational[1, 2]}, {
        0.09999999999999998, 0.9, 0.5}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 1.1, 0}, {0.9, 1.1, 0}], 
      CuboidBox[{0.09999999999999998, 1.9, 0}, {0.9, 1.9, 0}], 
      CuboidBox[{0.9, 1.1, 0}, {0.9, 1.9, 0}], 
      CuboidBox[{0.09999999999999998, 1.1, 0}, {0.09999999999999998, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 2.1, 0}, {0.9, 2.1, 0}], 
      CuboidBox[{0.09999999999999998, 2.9, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.9, 2.1, 0}, {0.9, 2.9, 0}], 
      CuboidBox[{0.09999999999999998, 2.1, 0}, {0.09999999999999998, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{0.09999999999999998, 3.1, 0}, {0.9, 3.1, 0}], 
      CuboidBox[{0.09999999999999998, 3.9, 0}, {0.9, 3.9, 0}], 
      CuboidBox[{0.9, 3.1, 0}, {0.9, 3.9, 0}], 
      CuboidBox[{0.09999999999999998, 3.1, 0}, {0.09999999999999998, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.9, 0.09999999999999998, 0}],
       CuboidBox[{1.1, 0.9, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.9, 0.09999999999999998, 0}, {1.9, 0.9, 0}], 
      CuboidBox[{1.1, 0.09999999999999998, 0}, {1.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{1.1, 1.1, 0}, 
       NCache[{1.9, 1.1, Rational[1, 2]}, {1.9, 1.1, 0.5}]], 
      CuboidBox[{1.1, 1.9, 0}, 
       NCache[{1.9, 1.9, Rational[1, 2]}, {1.9, 1.9, 0.5}]], 
      CuboidBox[{1.9, 1.1, 0}, 
       NCache[{1.9, 1.9, Rational[1, 2]}, {1.9, 1.9, 0.5}]], 
      CuboidBox[{1.1, 1.1, 0}, 
       NCache[{1.1, 1.9, Rational[1, 2]}, {1.1, 1.9, 0.5}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 2.1, 0}, {1.9, 2.1, 0}], 
      CuboidBox[{1.1, 2.9, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.9, 2.1, 0}, {1.9, 2.9, 0}], 
      CuboidBox[{1.1, 2.1, 0}, {1.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{1.1, 3.1, 0}, {1.9, 3.1, 0}], 
      CuboidBox[{1.1, 3.9, 0}, {1.9, 3.9, 0}], 
      CuboidBox[{1.9, 3.1, 0}, {1.9, 3.9, 0}], 
      CuboidBox[{1.1, 3.1, 0}, {1.1, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.9, 0.09999999999999998, 0}],
       CuboidBox[{2.1, 0.9, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.9, 0.09999999999999998, 0}, {2.9, 0.9, 0}], 
      CuboidBox[{2.1, 0.09999999999999998, 0}, {2.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 1.1, 0}, {2.9, 1.1, 0}], 
      CuboidBox[{2.1, 1.9, 0}, {2.9, 1.9, 0}], 
      CuboidBox[{2.9, 1.1, 0}, {2.9, 1.9, 0}], 
      CuboidBox[{2.1, 1.1, 0}, {2.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{2.1, 2.1, 0}, 
       NCache[{2.9, 2.1, Rational[-1, 2]}, {2.9, 2.1, -0.5}]], 
      CuboidBox[{2.1, 2.9, 0}, 
       NCache[{2.9, 2.9, Rational[-1, 2]}, {2.9, 2.9, -0.5}]], 
      CuboidBox[{2.9, 2.1, 0}, 
       NCache[{2.9, 2.9, Rational[-1, 2]}, {2.9, 2.9, -0.5}]], 
      CuboidBox[{2.1, 2.1, 0}, 
       NCache[{2.1, 2.9, Rational[-1, 2]}, {2.1, 2.9, -0.5}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{2.1, 3.1, 0}, {2.9, 3.1, 0}], 
      CuboidBox[{2.1, 3.9, 0}, {2.9, 3.9, 0}], 
      CuboidBox[{2.9, 3.1, 0}, {2.9, 3.9, 0}], 
      CuboidBox[{2.1, 3.1, 0}, {2.1, 3.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{
      CuboidBox[{3.1, 0.09999999999999998, 0}, {3.9, 0.09999999999999998, 0}],
       CuboidBox[{3.1, 0.9, 0}, {3.9, 0.9, 0}], 
      CuboidBox[{3.9, 0.09999999999999998, 0}, {3.9, 0.9, 0}], 
      CuboidBox[{3.1, 0.09999999999999998, 0}, {3.1, 0.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{3.1, 1.1, 0}, {3.9, 1.1, 0}], 
      CuboidBox[{3.1, 1.9, 0}, {3.9, 1.9, 0}], 
      CuboidBox[{3.9, 1.1, 0}, {3.9, 1.9, 0}], 
      CuboidBox[{3.1, 1.1, 0}, {3.1, 1.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    StyleBox[{CuboidBox[{3.1, 2.1, 0}, {3.9, 2.1, 0}], 
      CuboidBox[{3.1, 2.9, 0}, {3.9, 2.9, 0}], 
      CuboidBox[{3.9, 2.1, 0}, {3.9, 2.9, 0}], 
      CuboidBox[{3.1, 2.1, 0}, {3.1, 2.9, 0}]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {Opacity[0.7], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    FaceForm[RGBColor[0.7, 0.7, 1]], 
    StyleBox[{
      CuboidBox[{3.1, 3.1, 0}, 
       NCache[{3.9, 3.1, Rational[-1, 2]}, {3.9, 3.1, -0.5}]], 
      CuboidBox[{3.1, 3.9, 0}, 
       NCache[{3.9, 3.9, Rational[-1, 2]}, {3.9, 3.9, -0.5}]], 
      CuboidBox[{3.9, 3.1, 0}, 
       NCache[{3.9, 3.9, Rational[-1, 2]}, {3.9, 3.9, -0.5}]], 
      CuboidBox[{3.1, 3.1, 0}, 
       NCache[{3.1, 3.9, Rational[-1, 2]}, {3.1, 3.9, -0.5}]]},
     Lighting->{{"Ambient", 
        GrayLevel[1]}}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{0.09999999999999998, 0.09999999999999998, 0.499}, 
     NCache[{0.9, 0.9, Rational[1, 2]}, {0.9, 0.9, 0.5}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 1.1, -0.001}, {0.9, 1.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 2.1, -0.001}, {0.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{0.09999999999999998, 3.1, -0.001}, {0.9, 3.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 0.09999999999999998, -0.001}, {1.9, 0.9, 0}]}, 
   {RGBColor[0.4, 0.4, 1.], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[
    Tiny]}], CuboidBox[{1.1, 1.1, 0.499}, 
     NCache[{1.9, 1.9, Rational[1, 2]}, {1.9, 1.9, 0.5}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 2.1, -0.001}, {1.9, 2.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{1.1, 3.1, -0.001}, {1.9, 3.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 0.09999999999999998, -0.001}, {2.9, 0.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 1.1, -0.001}, {2.9, 1.9, 0}]}, 
   {EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], FaceForm[RGBColor[
    0.1, 0.1, 0.5]], 
    CuboidBox[{2.1, 2.1, -0.501}, 
     NCache[{2.9, 2.9, Rational[-1, 2]}, {2.9, 2.9, -0.5}]]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{2.1, 3.1, -0.001}, {2.9, 3.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 0.09999999999999998, -0.001}, {3.9, 0.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 1.1, -0.001}, {3.9, 1.9, 0}]}, 
   {RGBColor[1, 1, 1], EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], 
    CuboidBox[{3.1, 2.1, -0.001}, {3.9, 2.9, 0}]}, 
   {EdgeForm[{RGBColor[0.5, 0.5, 0.7], Thickness[Tiny]}], FaceForm[RGBColor[
    0.1, 0.1, 0.5]], 
    CuboidBox[{3.1, 3.1, -0.501}, 
     NCache[{3.9, 3.9, Rational[-1, 2]}, {3.9, 3.9, -0.5}]]}, {Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftBracketingBar]\[Alpha]\[Alpha]\[RightAngleBracket]\"\
\>",
        TraditionalForm], "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {4.6, 0.5, 0}], Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftBracketingBar]\[Alpha]\[Beta]\[RightAngleBracket]\"\
\>",
        TraditionalForm], "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {4.6, 1.5, 0}], Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftBracketingBar]\[Beta]\[Alpha]\[RightAngleBracket]\"\
\>",
        TraditionalForm], "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {4.6, 2.5, 0}], Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftBracketingBar]\[Beta]\[Beta]\[RightAngleBracket]\"\>\
",
        TraditionalForm], "Title",
       StripOnInput->False,
       FontSize->14], TraditionalForm], {4.6, 3.5, 0}]}, {Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftAngleBracket]\[Alpha]\[Alpha]\[RightBracketingBar]\"\
\>",
        TraditionalForm], "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {0.5, 4.8, 0}], Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftAngleBracket]\[Alpha]\[Beta]\[RightBracketingBar]\"\
\>",
        TraditionalForm], "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {1.5, 4.8, 0}], Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftAngleBracket]\[Beta]\[Alpha]\[RightBracketingBar]\"\
\>",
        TraditionalForm], "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {2.5, 4.8, 0}], Text3DBox[
     FormBox[
      StyleBox[
       FormBox["\<\"\[LeftAngleBracket]\[Beta]\[Beta]\[RightBracketingBar]\"\>\
",
        TraditionalForm], "Title",
       StripOnInput->False,
       TextAlignment->Left,
       FontSize->14], TraditionalForm], {3.5, 4.8, 0}]}},
  Boxed->False,
  SphericalRegion->True,
  ViewPoint->{2, -2, 2},
  ViewVertical->{0, 0, 1}]], "Output",
 CellChangeTimes->{
  3.513568122250315*^9, 3.5135695558917904`*^9, 3.5135701329816046`*^9, 
   3.528643473872789*^9, {3.5286435049074144`*^9, 3.5286435666962624`*^9}, {
   3.52864381500331*^9, 3.528643840119426*^9}, {3.528646038740888*^9, 
   3.5286460611931725`*^9}, 3.528648650616581*^9, 3.5286992682401533`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["High quality export", "Section",
 CellChangeTimes->{{3.51349891636276*^9, 3.513498921259802*^9}, {
  3.513499121137211*^9, 3.5134991275263987`*^9}, {3.5135200520760717`*^9, 
  3.513520052556763*^9}, {3.528644455283989*^9, 3.528644458919216*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSpinSystem", "[", "2", "]"}]], "Input",
 CellChangeTimes->{{3.5286443352814336`*^9, 3.528644339026819*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSpinSystem", "::", "\<\"set\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"the spin system has been set \
to \\\\\\\"\\\", \\\"MT\\\"]\\)\[NoBreak]\\!\\(\\*StyleBox[\\!\\({\\(\\({1, 1\
\\/2}\\)\\), \\(\\({2, 1\\/2}\\)\\)}\\), \\\"MT\\\"]\\)\[NoBreak]\"\>"}]], \
"Message", "MSG",
 CellChangeTimes->{3.528699269722285*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"MatrixPlot3D", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MatrixRepresentation", "[", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"opI", "[", 
         RowBox[{"1", ",", "\"\<z\>\""}], "]"}], "-", 
        RowBox[{"opI", "[", 
         RowBox[{"2", ",", "\"\<z\>\""}], "]"}]}], ")"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RowLabels", "\[Rule]", " ", 
      RowBox[{"BasisBras", "[", "]"}]}], ",", 
     RowBox[{"ColumnLabels", "\[Rule]", " ", 
      RowBox[{"BasisKets", "[", "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "400"}]}], "\[IndentingNewLine]", "]"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"ImageResolution", "\[Rule]", "200"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5135098587070785`*^9, 3.513509865176381*^9}, {
   3.5135117845262704`*^9, 3.5135118330961103`*^9}, {3.5135814360495214`*^9, 
   3.5135814370709906`*^9}, {3.513581553708707*^9, 3.513581565816117*^9}, 
   3.513581767355917*^9, {3.5286442842280226`*^9, 3.5286443981918945`*^9}, {
   3.528644466960779*^9, 3.528644511164341*^9}}],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzs3XtwVeX5wHtmzskkXCZ/MWMHC5mA5SKIoCm0pjC/yhRGdEpRWo7YWsYR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   "], {{0, 0}, {399.96, 400.32}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{399.96, 400.32},
  PlotRange->{{0, 399.96}, {0, 400.32}}]], "Output",
 CellChangeTimes->{{3.5286443750586305`*^9, 3.5286444323610272`*^9}, 
   3.5286445135778112`*^9, {3.528646038841032*^9, 3.5286460651188173`*^9}, 
   3.528648650816869*^9, 3.5286992722158704`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{476, 713},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowSelection->True,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "Info3528702837-3198673"->{
  Cell[1758, 53, 317, 6, 126, "Print",
   CellTags->"Info3528702837-3198673"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"Info3528702837-3198673", 161625, 3070}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 239, 4, 31, "Input"],
Cell[809, 28, 223, 3, 23, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1069, 36, 332, 4, 83, "Title"],
Cell[1404, 42, 101, 1, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1530, 47, 225, 4, 31, "Input"],
Cell[1758, 53, 317, 6, 126, "Print",
 CellTags->"Info3528702837-3198673"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2112, 64, 111, 1, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2248, 69, 256, 3, 71, "Section"],
Cell[CellGroupData[{
Cell[2529, 76, 130, 2, 31, "Input"],
Cell[2662, 80, 343, 5, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3042, 90, 287, 4, 31, "Input"],
Cell[3332, 96, 714, 13, 21, "Message"],
Cell[4049, 111, 1170, 16, 30, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5268, 133, 152, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[5445, 139, 619, 14, 31, "Input"],
Cell[6067, 155, 6364, 118, 375, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12468, 278, 174, 3, 31, "Input"],
Cell[12645, 283, 18728, 355, 321, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31422, 644, 255, 3, 71, "Section"],
Cell[CellGroupData[{
Cell[31702, 651, 141, 2, 31, "Input"],
Cell[31846, 655, 498, 10, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32381, 670, 602, 15, 52, "Input"],
Cell[32986, 687, 4028, 82, 321, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37051, 774, 1017, 26, 92, "Input"],
Cell[38071, 802, 4719, 98, 321, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42839, 906, 137, 1, 97, "Section"],
Cell[CellGroupData[{
Cell[43001, 911, 451, 13, 52, "Input"],
Cell[43455, 926, 4022, 81, 321, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47514, 1012, 474, 13, 52, "Input"],
Cell[47991, 1027, 401, 8, 39, "Message"],
Cell[48395, 1037, 176, 2, 30, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48632, 1046, 111, 1, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[48768, 1051, 274, 3, 71, "Section"],
Cell[49045, 1056, 149, 2, 31, "Input"],
Cell[CellGroupData[{
Cell[49219, 1062, 748, 17, 152, "Input"],
Cell[49970, 1081, 504, 10, 21, "Message"],
Cell[50477, 1093, 640, 12, 39, "Message"],
Cell[51120, 1107, 7889, 170, 315, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[59046, 1282, 709, 17, 152, "Input"],
Cell[59758, 1301, 561, 10, 58, "Message"],
Cell[60322, 1313, 697, 12, 87, "Message"],
Cell[61022, 1327, 11736, 249, 321, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72807, 1582, 251, 3, 71, "Section"],
Cell[CellGroupData[{
Cell[73083, 1589, 134, 2, 31, "Input"],
Cell[73220, 1593, 381, 8, 58, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73638, 1606, 1194, 24, 212, "Input"],
Cell[74835, 1632, 86348, 1419, 415, 55638, 914, "CachedBoxData", "BoxData", \
"Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
