(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29246,        720]
NotebookOptionsPosition[     27223,        643]
NotebookOutlinePosition[     27620,        660]
CellTagsIndexPosition[     27577,        657]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["MatrixPlot3D`", "Title",
 PageWidth->WindowWidth,
 Evaluatable->False,
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{
  3.467439256*^9, {3.528548079455902*^9, 3.5285480840124545`*^9}},
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"BeginPackage", "[", 
   RowBox[{"\"\<MatrixPlot3D`\>\"", ",", "\[IndentingNewLine]", 
    RowBox[{"{", "\"\<Global`\>\"", "\[IndentingNewLine]", "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.46738766290625*^9, 3.467387699203125*^9, {3.467389895234375*^9, 
   3.467389895578125*^9}, {3.46743924765625*^9, 3.467439248015625*^9}, {
   3.46748377659375*^9, 3.467483783390625*^9}, {3.46752341775*^9, 
   3.46752341909375*^9}, {3.46769708565625*^9, 3.46769708671875*^9}, {
   3.46830717990625*^9, 3.468307237640625*^9}, {3.526669846624756*^9, 
   3.5266698473737984`*^9}, {3.5279292790536356`*^9, 
   3.5279292795856657`*^9}, {3.5281331305916862`*^9, 3.528133131420734*^9}, {
   3.528548086706328*^9, 3.5285480891698704`*^9}}],

Cell[CellGroupData[{

Cell["Usage messages", "Subsubtitle",
 PageWidth->WindowWidth,
 Evaluatable->False,
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.467706116984375*^9, 3.46770611759375*^9}, {
  3.5285251460038495`*^9, 3.5285251580712013`*^9}},
 AspectRatioFixed->True],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPlot3D", "::", "usage"}], " ", "=", " ", "\n", 
   "\"\<MatrixPlot3D[matrix, displayoptions] provides 3D visualization of \
real matrices. \n\nExample: MatrixPlot3D[{{0,1,0},{1,0,0},{0,0,1}}]\n\n\
Compare with MatrixPlot\>\""}], ";"}]], "Input",
 CellChangeTimes->{
  3.5285481658601456`*^9, {3.528548214219683*^9, 3.52854825099256*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Subsubtitle",
 CellChangeTimes->{{3.5286263177636433`*^9, 3.5286263220498066`*^9}, 
   3.5286458183640013`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "MatrixPlot3D", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"RowLabels", "\[Rule]", "False"}], ",", 
     RowBox[{"ColumnLabels", "\[Rule]", "False"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPlot3DLabels", "[", "options___Rule", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"RowLabels", ",", "ColumnLabels"}], "}"}], "/.", 
     RowBox[{"FilterRules", "[", 
      RowBox[{
       RowBox[{"{", "options", "}"}], ",", 
       RowBox[{"Options", "[", "MatrixPlot3D", "]"}]}], "]"}]}], "/.", 
    RowBox[{"Options", "[", "MatrixPlot3D", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5285485304844494`*^9, 3.5285485481097937`*^9}, {
   3.528624204675171*^9, 3.528624301354189*^9}, 3.528624352377557*^9, {
   3.528624406305101*^9, 3.528624426363944*^9}, {3.528624571192197*^9, 
   3.528624573695797*^9}, {3.528626196088683*^9, 3.5286262008254943`*^9}, {
   3.528626326926819*^9, 3.5286263317637744`*^9}, {3.5286427536070976`*^9, 
   3.528642767216667*^9}, {3.52864575397141*^9, 3.5286457614020944`*^9}, {
   3.528645878009768*^9, 3.528645879892475*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Start", "Subsubtitle",
 InitializationCell->True,
 CellChangeTimes->{{3.467439836671875*^9, 3.4674398383125*^9}, {
  3.4674402751875*^9, 3.467440275484375*^9}, {3.5285252210617776`*^9, 
  3.528525222283534*^9}, {3.5285275785316525`*^9, 3.5285275787719984`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.467388742109375*^9, 3.4673887805625*^9}, {
  3.467388851125*^9, 3.467388880890625*^9}, {3.5285276021355934`*^9, 
  3.5285276063616705`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Error messages", "Subsubtitle",
 CellChangeTimes->{{3.5281826285685806`*^9, 3.528182630164672*^9}, {
  3.528525135468701*^9, 3.528525137671869*^9}}],

Cell[CellGroupData[{

Cell["Inappropriateinput", "Subsection",
 CellChangeTimes->{{3.5285481891636543`*^9, 3.5285481945514016`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPlot3D", "::", "inappropriateinput"}], " ", "=", " ", 
   "\"\<Input must be MatrixQ\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.5135024759211535`*^9, 3.5135025391821184`*^9}, {
   3.5135026034745665`*^9, 3.513502623513381*^9}, {3.513503772996256*^9, 
   3.5135037854341407`*^9}, 3.513505505106909*^9, 3.513505544793976*^9, 
   3.5135055929832687`*^9, 3.5135058346006975`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mismatcheddimensions", "Subsection",
 CellChangeTimes->{{3.5285481891636543`*^9, 3.5285481945514016`*^9}, {
  3.5285567454670143`*^9, 3.528556753348347*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPlot3D", "::", "mismatcheddimensions"}], " ", "=", " ", 
   "\"\<Basis labels incompatible with the matrix dimensions\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.5135024759211535`*^9, 3.5135025391821184`*^9}, {
   3.5135026034745665`*^9, 3.513502623513381*^9}, {3.513503772996256*^9, 
   3.5135037854341407`*^9}, 3.513505505106909*^9, 3.513505544793976*^9, 
   3.5135055929832687`*^9, 3.5135058346006975`*^9, {3.528556758005043*^9, 
   3.528556821946987*^9}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["MatrixPlot3D", "Subsubtitle",
 CellChangeTimes->{{3.5281862852397304`*^9, 3.5281862921991286`*^9}, {
  3.528525747208339*^9, 3.528525748510211*^9}, {3.5285262381743135`*^9, 
  3.528526239055581*^9}, {3.52854826876812*^9, 3.5285482711916046`*^9}}],

Cell[CellGroupData[{

Cell["MatrixPlot3D", "Section",
 CellChangeTimes->{{3.52863382315219*^9, 3.5286338265671005`*^9}, {
  3.5286343850000877`*^9, 3.528634385150304*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixPlot3D", "[", 
   RowBox[{"matrix_", ",", "options___Rule"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "mat", ",", "testmat", ",", "d", ",", "d1", ",", "dv", ",", "tiles", ",",
       "sides", ",", "rowlabels", ",", "columnlabels", ",", "testrowsize", 
      ",", "testcolumnsize", ",", "labelc", ",", "labelr"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{"Reject", " ", "unless", " ", "MatrixQ"}], "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"mat", ":=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"matrix", "//", "Normal"}], "//", "Re"}], ")"}], "/;", 
       RowBox[{"MatrixQ", "[", "matrix", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"testmat", ":=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{"MatrixPlot3D", "::", "inappropriateinput"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Abort", "[", "]"}], ";"}], ")"}], "/;", 
       RowBox[{"Not", "[", 
        RowBox[{"MatrixQ", "[", "matrix", "]"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", "testmat", ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Default", " ", "scaling", " ", "parameters"}], "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"d", "=", "0.9"}], ";", 
     RowBox[{"d1", "=", 
      RowBox[{"1", "-", "d"}]}], ";", 
     RowBox[{"dv", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "-", "d"}], ",", 
        RowBox[{"1", "-", "d"}], ",", "0"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Top", " ", "faces"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"tiles", "=", 
      RowBox[{"Array", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Graphics3D", "\[IndentingNewLine]", "[", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"mat", "\[LeftDoubleBracket]", 
                RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}], 
               "\[Equal]", "0"}], ",", 
              RowBox[{"Lighter", "[", 
               RowBox[{"Gray", ",", "1"}], "]"}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"mat", "\[LeftDoubleBracket]", 
                  RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}], ">", 
                 "0."}], ",", 
                RowBox[{"Lighter", "[", 
                 RowBox[{"Blue", ",", ".4"}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"FaceForm", "[", 
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0.1", ",", "0.1", ",", ".5"}], "]"}], "]"}]}], 
               "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"EdgeForm", "[", 
             RowBox[{"{", 
              RowBox[{"Thin", ",", 
               RowBox[{"RGBColor", "[", 
                RowBox[{"0.5", ",", "0.5", ",", "0.7"}], "]"}]}], "}"}], 
             "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Cuboid", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "1"}], ",", 
                 RowBox[{"#2", "-", "1"}], ",", 
                 RowBox[{
                  RowBox[{"mat", "\[LeftDoubleBracket]", 
                   RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}], "-", 
                  "0.001"}]}], "}"}], "+", "dv"}], ",", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"#1", ",", "#2", ",", 
                 RowBox[{"mat", "\[LeftDoubleBracket]", 
                  RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}]}], 
                "}"}], "-", "dv"}]}], "]"}]}], "\[IndentingNewLine]", "}"}], 
          "]"}], "&"}], ",", 
        RowBox[{"Dimensions", "@", "mat"}]}], "\[IndentingNewLine]", "]"}]}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"(*", 
      RowBox[{"Side", " ", "faces"}], "*)"}], "\[IndentingNewLine]", 
     RowBox[{"sides", "=", 
      RowBox[{
       RowBox[{"Array", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Graphics3D", "\[IndentingNewLine]", "[", 
           RowBox[{"{", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"mat", "\[LeftDoubleBracket]", 
                 RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}], 
                "\[Equal]", "0"}], ",", 
               RowBox[{"Opacity", "[", "0", "]"}], ",", 
               RowBox[{"FaceForm", "[", 
                RowBox[{"{", 
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0.7", ",", "0.7", ",", "1"}], "]"}], "}"}], 
                "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"EdgeForm", "[", 
              RowBox[{"{", 
               RowBox[{"Thin", ",", 
                RowBox[{"RGBColor", "[", 
                 RowBox[{"0.5", ",", "0.5", ",", "0.7"}], "]"}]}], "}"}], 
              "]"}], ",", 
             RowBox[{"Lighting", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"{", 
                RowBox[{"\"\<Ambient\>\"", ",", "White"}], "}"}], "}"}]}], 
             ",", 
             RowBox[{"Opacity", "[", ".7", "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cuboid", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "1", "+", "d1"}], ",", 
                 RowBox[{"#2", "-", "1", "+", "d1"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "d1"}], ",", 
                 RowBox[{"#2", "-", "1", "+", "d1"}], ",", 
                 RowBox[{"mat", "\[LeftDoubleBracket]", 
                  RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}]}], 
                "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cuboid", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "1", "+", "d1"}], ",", 
                 RowBox[{"#2", "-", "d1"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "d1"}], ",", 
                 RowBox[{"#2", "-", "d1"}], ",", 
                 RowBox[{"mat", "\[LeftDoubleBracket]", 
                  RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}]}], 
                "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cuboid", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "d1"}], ",", 
                 RowBox[{"#2", "-", "1", "+", "d1"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "d1"}], ",", 
                 RowBox[{"#2", "-", "d1"}], ",", 
                 RowBox[{"mat", "\[LeftDoubleBracket]", 
                  RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}]}], 
                "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
             RowBox[{"Cuboid", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "1", "+", "d1"}], ",", 
                 RowBox[{"#2", "-", "1", "+", "d1"}], ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "-", "1", "+", "d1"}], ",", 
                 RowBox[{"#2", "-", "d1"}], ",", 
                 RowBox[{"mat", "\[LeftDoubleBracket]", 
                  RowBox[{"#1", ",", "#2"}], "\[RightDoubleBracket]"}]}], 
                "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}], "]"}], "&"}], 
         ",", 
         RowBox[{"Dimensions", "@", "mat"}]}], "]"}], "//", "Flatten"}]}], 
     ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"rowlabels", ",", "columnlabels"}], "}"}], "=", 
      RowBox[{"MatrixPlot3DLabels", "@@", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{"{", "options", "}"}], ",", 
         RowBox[{"Options", "[", "MatrixPlot3D", "]"}]}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"testrowsize", ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{"MatrixPlot3D", "::", "mismatcheddimensions"}], "]"}], ";", 
          RowBox[{"Abort", "[", "]"}]}], ")"}], "/;", 
        RowBox[{"Not", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Length", "[", "rowlabels", "]"}], "===", 
           RowBox[{"Length", "[", 
            RowBox[{"Normal", "[", "matrix", "]"}], "]"}]}], ")"}], "]"}]}], "/;", 
       RowBox[{"ListQ", "[", "rowlabels", "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"testcolumnsize", ":=", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Message", "[", 
           RowBox[{"MatrixPlot3D", "::", "mismatcheddimensions"}], "]"}], ";", 
          RowBox[{"Abort", "[", "]"}]}], ")"}], "/;", 
        RowBox[{"Not", "[", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Length", "[", "columnlabels", "]"}], "===", 
           RowBox[{"Length", "[", 
            RowBox[{
             RowBox[{"Normal", "[", "matrix", "]"}], "\[LeftDoubleBracket]", 
             "1", "\[RightDoubleBracket]"}], "]"}]}], ")"}], "]"}]}], "/;", 
       RowBox[{"ListQ", "[", "columnlabels", "]"}]}]}], ";", 
     "\[IndentingNewLine]", "testrowsize", ";", "testcolumnsize", ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"labelr", "=", 
        RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{
               "rowlabels", "\[LeftDoubleBracket]", "#", 
                "\[RightDoubleBracket]"}], ",", "\"\<Title\>\"", ",", 
               RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
               RowBox[{"TextAlignment", "\[Rule]", "Left"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#", "-", "0.5"}], ",", 
               RowBox[{"1.2", 
                RowBox[{"(", 
                 RowBox[{"Length", "[", 
                  RowBox[{
                   RowBox[{"Normal", "[", "matrix", "]"}], 
                   "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                  "]"}], ")"}]}], ",", "0"}], "}"}]}], "]"}], "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"Length", "@", "rowlabels"}], "]"}]}], "]"}]}], ")"}], "/;", 
      RowBox[{"ListQ", "[", "rowlabels", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"labelc", "=", 
        RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Text", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{
               "columnlabels", "\[LeftDoubleBracket]", "#", 
                "\[RightDoubleBracket]"}], ",", "\"\<Title\>\"", ",", "14"}], 
              "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1.15", 
                RowBox[{"(", 
                 RowBox[{"Length", "[", 
                  RowBox[{"Normal", "[", "matrix", "]"}], "]"}], ")"}]}], ",", 
               RowBox[{"#", "-", "0.5"}], ",", "0"}], "}"}]}], "]"}], 
           "\[IndentingNewLine]", "&"}], "/@", 
          RowBox[{"Range", "[", 
           RowBox[{"Length", "@", "columnlabels"}], "]"}]}], "]"}]}], ")"}], "/;", 
      RowBox[{"ListQ", "[", "columnlabels", "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", "Show", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{
      "sides", ",", "tiles", ",", "labelc", ",", "labelr", ",", 
       "\[IndentingNewLine]", 
       RowBox[{"FilterRules", "[", 
        RowBox[{
         RowBox[{"{", "options", "}"}], ",", 
         RowBox[{"Options", "[", "Graphics3D", "]"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ViewPoint", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"2", ",", 
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"ViewVertical", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.513494200572056*^9, 3.5134943302385073`*^9}, {
   3.513494368864048*^9, 3.5134943963635902`*^9}, {3.5134944383840127`*^9, 
   3.5134944388246465`*^9}, {3.5134944689379473`*^9, 3.513494474395795*^9}, {
   3.513494605884867*^9, 3.513494695864251*^9}, {3.513494772013749*^9, 
   3.5134948213046255`*^9}, {3.5134952589739633`*^9, 
   3.5134953852154894`*^9}, {3.5134986984394016`*^9, 
   3.5134987728463936`*^9}, {3.5134989890272465`*^9, 3.513498998330624*^9}, {
   3.513499093036805*^9, 3.5134990933071938`*^9}, {3.5134992645734625`*^9, 
   3.513499281858317*^9}, 3.5134995408807726`*^9, {3.5134995904220095`*^9, 
   3.5134996160989313`*^9}, {3.51349964766432*^9, 3.513499651349619*^9}, 
   3.513499693179768*^9, {3.5134997257866545`*^9, 3.513499740838298*^9}, {
   3.513499850596122*^9, 3.51349995710928*^9}, {3.513500066446499*^9, 
   3.513500155214141*^9}, {3.51350049738616*^9, 3.5135004983775854`*^9}, {
   3.51350095554496*^9, 3.5135009728798866`*^9}, {3.5135015543359795`*^9, 
   3.51350155875233*^9}, {3.513501928123459*^9, 3.5135019316986*^9}, {
   3.513502099169411*^9, 3.5135021202296944`*^9}, {3.513502165564883*^9, 
   3.513502241594208*^9}, {3.513502560072157*^9, 3.513502585348502*^9}, {
   3.5135029175762224`*^9, 3.5135029338295937`*^9}, {3.513502970111765*^9, 
   3.513503040372795*^9}, {3.5135030736907043`*^9, 3.5135031607558975`*^9}, {
   3.5135033953932896`*^9, 3.513503546290269*^9}, {3.513503590113283*^9, 
   3.5135036311022224`*^9}, {3.5135036774388514`*^9, 
   3.5135037109971056`*^9}, {3.51350389602316*^9, 3.513504132923806*^9}, {
   3.5135041668225503`*^9, 3.5135041882333374`*^9}, {3.513504316107211*^9, 
   3.513504317178752*^9}, {3.513504453695053*^9, 3.513504460615003*^9}, {
   3.5135045838421955`*^9, 3.513504584713448*^9}, {3.5135046525710225`*^9, 
   3.5135046543936434`*^9}, {3.5135046968647137`*^9, 3.5135047257162*^9}, {
   3.513504757792323*^9, 3.513504835974744*^9}, {3.5135049643192945`*^9, 
   3.513504971048971*^9}, {3.5135050379051056`*^9, 3.51350506679665*^9}, {
   3.5135051211347837`*^9, 3.5135051856175056`*^9}, {3.5135052301114845`*^9, 
   3.5135053061107664`*^9}, {3.513505339809222*^9, 3.51350539242488*^9}, {
   3.513505613142256*^9, 3.5135057057253838`*^9}, {3.513505872034525*^9, 
   3.5135058796454687`*^9}, 3.513506160759691*^9, {3.513506214186515*^9, 
   3.5135062564272547`*^9}, {3.513506359705762*^9, 3.513506362389621*^9}, {
   3.5135064028077393`*^9, 3.513506411540296*^9}, {3.513508940987462*^9, 
   3.51350894227932*^9}, {3.5135682969615374`*^9, 3.513568308267795*^9}, {
   3.513569899545941*^9, 3.513569906656165*^9}, {3.5135709417245197`*^9, 
   3.513570942024952*^9}, {3.5285502373387856`*^9, 3.528550281081685*^9}, {
   3.528550370089672*^9, 3.528550371141184*^9}, {3.528550451847234*^9, 
   3.5285504625325985`*^9}, {3.528550509339904*^9, 3.528550509660365*^9}, {
   3.528550635941949*^9, 3.5285506540680127`*^9}, {3.5285507095077314`*^9, 
   3.528550718690936*^9}, {3.528551926557763*^9, 3.5285519287108593`*^9}, {
   3.5285519861734867`*^9, 3.5285519913609457`*^9}, 3.5286236921682224`*^9, {
   3.528623759364846*^9, 3.5286237879259152`*^9}, {3.5286238512669954`*^9, 
   3.528623853109645*^9}, {3.528623924332058*^9, 3.528623956808757*^9}, {
   3.528633897048448*^9, 3.5286339232260895`*^9}, {3.528634300688854*^9, 
   3.5286343367106514`*^9}, {3.5286344226141744`*^9, 
   3.5286344270405393`*^9}, {3.528636081252723*^9, 3.5286360878421984`*^9}, {
   3.5286362345131006`*^9, 3.5286362550826783`*^9}, {3.5286362930372543`*^9, 
   3.528636366032216*^9}, {3.5286364159740286`*^9, 3.528636421391819*^9}, {
   3.528636451404976*^9, 3.528636648858901*^9}, {3.528636697719158*^9, 
   3.5286367330800047`*^9}, {3.52863692368408*^9, 3.5286369358315473`*^9}, {
   3.528636978152402*^9, 3.5286370058622465`*^9}, {3.5286370654479265`*^9, 
   3.5286370702648525`*^9}, {3.5286371054454403`*^9, 
   3.5286371324843197`*^9}, {3.528637176477579*^9, 3.528637192760994*^9}, {
   3.528637226038845*^9, 3.5286373019680257`*^9}, {3.528637335145733*^9, 
   3.5286374491496625`*^9}, {3.5286375432049074`*^9, 
   3.5286375460089393`*^9}, {3.5286375936874976`*^9, 
   3.5286375949392977`*^9}, {3.528637639663608*^9, 3.528637675835621*^9}, {
   3.5286379081697006`*^9, 3.52863791269621*^9}, {3.528637951231621*^9, 
   3.5286379703791533`*^9}, {3.5286380597576733`*^9, 
   3.5286381858389697`*^9}, {3.528638292702632*^9, 3.5286383276528883`*^9}, {
   3.528640980447419*^9, 3.52864101022023*^9}, {3.528642122439523*^9, 
   3.528642179641776*^9}, {3.5286422664365807`*^9, 3.528642270742773*^9}, {
   3.528642325401368*^9, 3.5286423288162785`*^9}, 3.5286425155247517`*^9, {
   3.528642731415187*^9, 3.5286427323865843`*^9}, {3.5286427826088*^9, 
   3.5286427877061296`*^9}, {3.5286429401252975`*^9, 
   3.5286429404257298`*^9}, {3.528644416157728*^9, 3.528644426622776*^9}, 
   3.528659262906304*^9, {3.528690384499163*^9, 3.528690385570704*^9}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version", "Subsubtitle",
 CellChangeTimes->{{3.52854864430812*^9, 3.528548645209416*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "MatrixPlot3DVersion", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"MatrixPlot3DVersion", "\[Rule]", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPlot3DVersion", "[", "opts___Rule", "]"}], ":=", 
   RowBox[{
    RowBox[{"MatrixPlot3DVersion", "/.", 
     RowBox[{"{", "opts", "}"}]}], "/.", 
    RowBox[{"Options", "[", "MatrixPlot3DVersion", "]"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.5285485304844494`*^9, 3.5285485481097937`*^9}, {
  3.528624344155734*^9, 3.528624344376051*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["End", "Subsubtitle",
 PageWidth->WindowWidth,
 Evaluatable->False,
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.46744013465625*^9, 3.467440135046875*^9}, {
  3.467533637046875*^9, 3.46753363765625*^9}},
 AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<MatrixPlot3D` version \>\"", "<>", 
    RowBox[{"ToString", "[", 
     RowBox[{"MatrixPlot3DVersion", "[", "]"}], "]"}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 InitializationGroup->True,
 CellChangeTimes->{{3.438873361365691*^9, 3.438873377379888*^9}, {
   3.43887341200403*^9, 3.438873432822756*^9}, {3.438873488064747*^9, 
   3.438873565036696*^9}, {3.438873605791306*^9, 3.4388736112663317`*^9}, {
   3.438940077451765*^9, 3.438940108557048*^9}, {3.46744014240625*^9, 
   3.46744024325*^9}, {3.46745700559375*^9, 3.46745700678125*^9}, {
   3.46753338359375*^9, 3.467533520015625*^9}, {3.467608830109375*^9, 
   3.467608831703125*^9}, 3.527929932800028*^9, {3.5281354752907953`*^9, 
   3.528135477600928*^9}, 3.528193024068516*^9, {3.528193622215728*^9, 
   3.5281937966487045`*^9}, {3.528437228418411*^9, 3.5284372286054215`*^9}, 
   3.5284564207042885`*^9, {3.528523276996349*^9, 3.5285232779577312`*^9}, {
   3.528525318561976*^9, 3.528525354383485*^9}, 3.5285277250723677`*^9, {
   3.5285375150004625`*^9, 3.5285375175240912`*^9}, {3.528548396151288*^9, 
   3.528548447224728*^9}, 3.528548552616274*^9, {3.528552119975885*^9, 
   3.5285521215481453`*^9}}],

Cell[BoxData["\<\"MatrixPlot3D` version 1\"\>"], "Print",
 CellChangeTimes->{
  3.5285542753551683`*^9, 3.5286238131221457`*^9, {3.5286239118641295`*^9, 
   3.528623912324792*^9}, {3.5286258685276737`*^9, 3.528625868888192*^9}, {
   3.528634064809677*^9, 3.5286340651501665`*^9}, {3.528637038018485*^9, 
   3.5286370383089027`*^9}, {3.528642849124445*^9, 3.528642849504992*^9}, 
   3.5286460222271423`*^9, {3.5286461777507744`*^9, 3.528646177870947*^9}}]
}, Open  ]],

Cell["\<\
End[];
EndPackage[];\
\>", "Input",
 PageWidth->WindowWidth,
 InitializationCell->True,
 InitializationGroup->True,
 AspectRatioFixed->True],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.52863669435432*^9}]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{789, 713},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 243, 7, 83, "Title",
 Evaluatable->False,
 InitializationCell->True,
 InitializationGroup->True],
Cell[813, 31, 820, 15, 92, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[1658, 50, 281, 7, 28, "Subsubtitle",
 Evaluatable->False,
 InitializationCell->True,
 InitializationGroup->True],
Cell[1942, 59, 390, 8, 132, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[2369, 72, 128, 2, 28, "Subsubtitle"],
Cell[2500, 76, 1199, 27, 92, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[3736, 108, 267, 4, 28, "Subsubtitle",
 InitializationCell->True],
Cell[4006, 114, 282, 6, 31, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[4325, 125, 154, 2, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[4504, 131, 110, 1, 36, "Subsection"],
Cell[4617, 134, 432, 8, 31, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5086, 147, 163, 2, 36, "Subsection"],
Cell[5252, 151, 518, 10, 31, "Input"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[5819, 167, 252, 3, 28, "Subsubtitle"],
Cell[CellGroupData[{
Cell[6096, 174, 149, 2, 71, "Section"],
Cell[6248, 178, 17923, 378, 1172, "Input"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24220, 562, 95, 1, 28, "Subsubtitle"],
Cell[24318, 565, 595, 15, 72, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[24950, 585, 265, 7, 28, "Subsubtitle",
 Evaluatable->False,
 InitializationCell->True,
 InitializationGroup->True],
Cell[CellGroupData[{
Cell[25240, 596, 1244, 22, 31, "Input",
 InitializationCell->True,
 InitializationGroup->True],
Cell[26487, 620, 454, 6, 23, "Print"]
}, Open  ]],
Cell[26956, 629, 150, 7, 48, "Input",
 InitializationCell->True,
 InitializationGroup->True],
Cell[27109, 638, 86, 1, 52, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
