(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



BeginPackage["MatrixPlot3D`",
{"Global`"
}
];


MatrixPlot3D::usage = 
"MatrixPlot3D[matrix, displayoptions] provides 3D visualization of real matrices. 

Example: MatrixPlot3D[{{0,1,0},{1,0,0},{0,0,1}}]

Compare with MatrixPlot";


Options[MatrixPlot3D]={RowLabels->False,ColumnLabels->False};
MatrixPlot3DLabels[options___Rule]:={RowLabels,ColumnLabels}/.FilterRules[{options},Options[MatrixPlot3D]]/.Options[MatrixPlot3D];


Begin["`Private`"];


MatrixPlot3D::inappropriateinput = "Input must be MatrixQ";


MatrixPlot3D::mismatcheddimensions = "Basis labels incompatible with the matrix dimensions";


MatrixPlot3D[matrix_,options___Rule]:=Module[{mat,testmat,d,d1,dv,tiles,sides,rowlabels,columnlabels,testrowsize,testcolumnsize,labelc,labelr},
(*Reject unless MatrixQ*)
mat:=(matrix//Normal//Re)/;MatrixQ[matrix];
testmat:=(Message[MatrixPlot3D::inappropriateinput];
Abort[];)/;Not[MatrixQ[matrix]];
testmat;
(*Default scaling parameters*)
d=0.9;d1=1-d;dv={1-d,1-d,0};
(*Top faces*)
tiles=Array[Graphics3D
[{
If[mat[[#1,#2]]==0,Lighter[Gray,1],If[mat[[#1,#2]]>0.,Lighter[Blue,.4],
FaceForm[RGBColor[0.1,0.1,.5]]]],
EdgeForm[{Thin,RGBColor[0.5,0.5,0.7]}],
Cuboid[{#1-1,#2-1,mat[[#1,#2]]-0.001}+dv,{#1,#2,mat[[#1,#2]]}-dv]
}]&,Dimensions@mat
];
(*Side faces*)
sides=Array[Graphics3D
[{
If[mat[[#1,#2]]==0,Opacity[0],FaceForm[{RGBColor[0.7,0.7,1]}]],
EdgeForm[{Thin,RGBColor[0.5,0.5,0.7]}],Lighting->{{"Ambient",White}},Opacity[.7],
Cuboid[{#1-1+d1,#2-1+d1,0},{#1-d1,#2-1+d1,mat[[#1,#2]]}],
Cuboid[{#1-1+d1,#2-d1,0},{#1-d1,#2-d1,mat[[#1,#2]]}],
Cuboid[{#1-d1,#2-1+d1,0},{#1-d1,#2-d1,mat[[#1,#2]]}],
Cuboid[{#1-1+d1,#2-1+d1,0},{#1-1+d1,#2-d1,mat[[#1,#2]]}]
}]&,Dimensions@mat]//Flatten;

{rowlabels,columnlabels}=MatrixPlot3DLabels@@FilterRules[{options},Options[MatrixPlot3D]];

testrowsize:=(Message[MatrixPlot3D::mismatcheddimensions];Abort[])/;Not[(Length[rowlabels]===Length[Normal[matrix]])]/;ListQ[rowlabels];
testcolumnsize:=(Message[MatrixPlot3D::mismatcheddimensions];Abort[])/;Not[(Length[columnlabels]===Length[Normal[matrix][[1]]])]/;ListQ[columnlabels];
testrowsize;testcolumnsize;

(labelr=Graphics3D[
Text[Style[rowlabels[[#]],"Title",FontSize->14,TextAlignment->Left],{#-0.5,1.2(Length[Normal[matrix][[1]]]),0}]&/@Range[Length@rowlabels]])/;ListQ[rowlabels];
(labelc=Graphics3D[
Text[Style[columnlabels[[#]],"Title",14],{1.15(Length[Normal[matrix]]),#-0.5,0}]
&/@Range[Length@columnlabels]])/;ListQ[columnlabels];

(*Show*)
Show[sides,tiles,labelc,labelr,
FilterRules[{options},Options[Graphics3D]],
ViewPoint->{2,-2,2},
ViewVertical->{0,0,1},
SphericalRegion->True,
Boxed->False]
]


Options[MatrixPlot3DVersion]={MatrixPlot3DVersion->1};
MatrixPlot3DVersion[opts___Rule]:=MatrixPlot3DVersion/.{opts}/.Options[MatrixPlot3DVersion];


Print["MatrixPlot3D` version "<>ToString[MatrixPlot3DVersion[]]];


End[];
EndPackage[];




